define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.controller('ConsentController', function ($scope, $state, $stateParams, consentService, globalDelayTracker, $modal, focusService) {
		$scope.globalDelayTracker = globalDelayTracker;
		var modalInstance;
		var modalInfo = {value: null, dismissed: true};
		
		$scope.noShowConsent = false;

		focusService.focusElement('.main-header h1');

		$scope.consent = function() {
			consentService.consent($scope.noShowConsent).then(function () {
				$state.go($stateParams.routeBase);
			});
		};

		$scope.dontConsent = function() {
			openModal('modules/ui-components/modals/consent-declined/consent-declined_template.html', 'ConsentDeclinedController', modalInfo);
		};
		
		$scope.cancel = function () {
			$state.go('main.app-select');
		};

		$scope.updateNoShow = function () {
			$scope.noShowConsent = !$scope.noShowConsent;
		};

		$scope.dial911 = function (event) {
			openModal('modules/ui-components/modals/confirm-dial/confirm-dial_template.html', 'ConfirmDialController', {id: event.currentTarget.id, href: "911"});
		};

		var dismissModal = function () {
			if (angular.isDefined(modalInstance) && !modalInfo.dismissed) {
				modalInfo.dismissed = true;
				modalInstance.dismiss();
			}
		};

		var openModal = function (template, controller, data) {
			dismissModal();

			modalInstance = $modal.open({
				windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
				templateUrl: template,
				controller: controller,
				backdrop: 'static',
				keyboard: false,
				resolve: {
					modalInfo: function () {
						return modalInfo;
					},
					params: function () {
						return data;
					}
				}
			});
		};
	});
});
