define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('videoService', function ($http, $q, localResourceDirectoryService, questionnaireResponseService) {
		var currMediaRequest = {};

		var service =  {
			getMediaRequest: function () {
				return currMediaRequest;
			},
			setMediaRequest: function (mediaRequest) {
				var deferred = $q.defer();

				currMediaRequest = mediaRequest;

                this.initEvaluation('MyVideo', mediaRequest.id,mediaRequest.questionnaireResponse).then(function () {
					deferred.resolve();
				});

				return deferred.promise;
			},
			setQuestionnaireResponseId: function (responseId) {
				currMediaRequest.questionnaireResponse = responseId;
			},
			transformResponse: function(response){
				var evaluation = {};
				var status = _.get(response, "status") ||  "NOT_STARTED";
				evaluation.mediaRequestId = _.get(response, "identifier.value") ||  "";
				evaluation.images = this.getVideo(response.group) || [];
				return evaluation;
			},
			updateResponse: function(){
				this.currResponse.group.group = [];
				var group = this.createVideoGroup();
				if(group)
					this.currResponse.group.group.push(group);
			},
			createVideoGroup: function () {
				var video = this.currEvaluation.images[0];
				var linkId = this.getLinkId("TAKE_VIDEO");
				var group;
				if(video) {
					group = {
						linkId: linkId,
						question: []
					};

					group.question.push(this.createAnswer(linkId + ".1", "string", (video || {}).id || ''));
					group.question.push(this.createAnswer(linkId + ".2", "string", (video || {}).imageDescription || ''));
				}
				return group;
			},
			getVideo :  function (jsonObject) {
				var videos = [];
				var video;
				var linkId = this.getLinkId("TAKE_VIDEO");
				var urlObj = this.findElement(jsonObject, linkId + ".1");
				if(urlObj) {
					var id = this.getValue(jsonObject, urlObj.linkId) || '';
					video = {
						id: id,
						imageUrl: this.resourceLinks['media'].replace("{MEDIA_ID}", id),
						imageDescription: this.getValue(jsonObject, linkId + ".2"),
						imageSection: {
							name: 'OTHER',
							description: 'Other'
						},
						imageType: {
							name: 'OTHER',
							description: 'Other'
						}
					};
				}
				videos.push(video);
				return videos;
			},
			setVideo : function (video) {
				this.currEvaluation.images = [video];
			},
			saveMediaRequest: function () {
				var deferred = $q.defer();
				var url = this.resourceLinks['update-request'];

				url = url.replace('{MEDIA_REQUEST_ID}', currMediaRequest.id);

				var updateObj = {
					status: currMediaRequest.status,
					questionnaireResponse :  currMediaRequest.questionnaireResponse
				};
				
				$http({
					method: 'PATCH',
					url: url, 
					data: JSON.stringify(updateObj)
				}).success(function () {
					deferred.resolve();
				}).error(function (error) {
					deferred.reject(error);
				});

				return deferred.promise;
			}
		}

		angular.extend(service, questionnaireResponseService);

		return service;
	});
});