define(['angular', 'app'], function (angular, app) {
    'use strict';

	app.service('videoUploadService', function ($q, fhirResources, videoService) {
		var BASE64_PLACEHOLDER = '[[base64-media]]';

        return {
            uploadVideo: function (file, data, saveEval) {
                saveEval = (typeof saveEval === 'undefined') ? true : saveEval;

                var deferred = $q.defer();
				var that = this;
				var video = data;

				var evaluation = videoService.getEvaluation(),
					method = data.id ? 'PUT' : 'POST',
					resourceName = data.id? 'Media/' + data.id : 'Media',
					media = that.createMedia(data.id, evaluation.mediaRequestId, file);

				fhirResources.appendProvenanceMetadata(media);
				media = JSON.stringify(media);
				var base64Index = media.indexOf(BASE64_PLACEHOLDER);

				that.getBase64(file).then(function (data) {
					media = data.replace("data:" + file.type + ";base64,", media.substring(0, base64Index))
						+ media.substring(base64Index + BASE64_PLACEHOLDER.length);

					var resourceConfig = {
						method: method,
						resourceName: resourceName,
						data: new Blob([media], {type : 'application/json'})
					};
					fhirResources.createUpdateFhirResource(resourceConfig).then(
						function (response) {
							video.id = response.split("/")[1];
							video.imageUrl = fhirResources.getFhirBaseUrl() + "/" + response;

							videoService.setVideo(video);

							if (saveEval) {
								videoService.saveEvaluation().then(function () {
									deferred.resolve();
								});
							} else {
								deferred.resolve();
							}
						},
						function (error) {
							deferred.reject(error);
						}
					);
				});

                return deferred.promise;
            },
			getBase64: function(file) {
				var deferred = $q.defer();
				var reader = new FileReader();
				reader.onload = function () {
					deferred.resolve(reader.result);
				};
				reader.onerror = function (error) {
					deferred.reject();
				};
				reader.readAsDataURL(file);

				return deferred.promise;
			},
			createMedia: function(videoId, mediaRequestId, file) {
				var response = {
					resourceType: 'Media',
					type: 'video',
					identifier: [{value: mediaRequestId}],
					subject: {reference: 'Patient/' + videoService.getPatient().id},
					content: {
						data: BASE64_PLACEHOLDER,
						contentType: file.type,
						size: file.size,
						title: file.name
					}
				};

				if(videoId)
					response.id = videoId;

				return response;
			}
        };
    });
});