define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('videoSubmitEvaluationService', function ($q, submitEvaluationService, videoService) {
        var service = {
            successRoute: 'main.myvideo.success',
            retryRoute: 'main.myvideo.retry',
            failedRoute: 'main.myvideo.failed',
            submitFunction: function () {
                var deferred = $q.defer();
				videoService.saveEvaluation().then(function () {
					videoService.saveMediaRequest().then(function () {
						deferred.resolve();
					}, function () {
						deferred.reject();
					});
				}, function () {
					deferred.reject();
				});
				return deferred.promise;
            }
        };

        angular.extend(service, submitEvaluationService);

        return service;
    });
});