define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.filter('trusted', ['$sce', function ($sce) {
        return function(url) {
            return $sce.trustAsResourceUrl(url);
        };
    }]);

    app.controller('VideoUploadController', function ($scope, $state, $timeout, focusService, videoService, fileValidationService, videoUploadService, $http, formatter, $modal, configServiceValues) {
        $scope.evaluation = videoService.getEvaluation();
        $scope.mediaRequest = videoService.getMediaRequest();
        $scope.currVideo = {};
        $scope.video = $scope.evaluation.images[0] || {};
        var originalVideo = angular.copy($scope.video);
        $scope.videoSelected = !!$scope.video && !!($scope.video.id && $scope.video.imageUrl);
        $scope.isIE11 = !!window.MSInputMethodContext && !!document.documentMode;
        $scope.infoUpdated = false;
        var modalInstance;

        if ($scope.videoSelected) {
            var videoObj = angular.element('#view-video');
            if (videoObj) {
                $http({
                    url: $scope.video.imageUrl,
                    method: 'GET',
                }).then(function (response) {
					videoObj[0].src = URL.createObjectURL(formatter.base64toBlob("data:"+response.data.content.contentType+";base64," + response.data.content.data));
                    videoObj[0].fileName = $scope.video.fileName = response.data.content.title;
					videoObj[0].load();
                });
            }
        }

        $scope.retakeVideo = function () {
			$scope.videoSelected = false;
			$scope.takeVideo();
		}

        $scope.takeVideo = function() {
            $scope.videoSelected = true;
            $scope.infoUpdated = true;
			
            $timeout(function () {
                focusService.focusElement('.media-container span');
            }, 700);
        };

        $scope.errorHandling = {
			'File-Size-Check' : {
				message : 'The video you’re attempting to upload is too large. Videos are limited to ' + configServiceValues.videoFileSizeLimit + ' MB. To reduce the video size, try taking a shorter video, changing the camera settings or using compression software.',
				priority : 1
            },
            'File-Type-Check' : {
                message : 'Videos must be one of the following types: mov or mp4',
                priority : 1
            }
        };

        $scope.validate = function () {
            $scope.validateFileSize();
            $scope.validateFileType();
        };

        $scope.validateFileSize = function () {
            var validFileSize = true;

            var maxFileSize = (configServiceValues.videoFileSizeLimit * 1024 * 1024) - 1; //Video file-size limit in MB converted to Bytes, minus 1 Byte per requirement;

            validFileSize = fileValidationService.validateFileSize($scope.currVideo.fileObj, maxFileSize);

            $scope.videoInputForm.$setValidity('File-Size-Check', validFileSize);
        };
        
        $scope.validateFileType = function () {
            var validFileType = true;
            
            var fileTypes = ['mov', 'mp4'];
            var fileName = '';

            if ($scope.currVideo.fileObj) {
                fileName = $scope.currVideo.fileObj.name;
            } else if ($scope.video && $scope.video.fileName) {
                fileName = $scope.video.fileName;
            }

            validFileType = fileValidationService.validateFileType(fileName, fileTypes);

            $scope.videoInputForm.$setValidity('File-Type-Check', validFileType);
        };

        $scope.acceptVideo = function() {
            if ($scope.video.imageDescription) {
                $scope.video.imageDescription = $scope.video.imageDescription.trim();
            }

            $scope.validate();
            $scope.videoInputForm.validationSummary.validate().then(function () {
                if ($scope.currVideo.fileObj) {
                    var data = $scope.video && $scope.video.id ? $scope.video : {
                        imageSection: {
							name: 'OTHER',
							description: 'Other'
						},
                        imageType: {
                            name: 'OTHER',
                            description: 'Other'
                        },
                        imageClass: 'PRIMARY',
                        imageDescription: $scope.video.imageDescription,
                        imageNumber: 1
                    };
    
                    data.fileName = $scope.currVideo.fileObj.name;
    
                    videoUploadService.uploadVideo($scope.currVideo.fileObj, data).then(function () {
                        $state.go('main.myvideo.video-submit');
                    });
                } else {
                    videoService.saveEvaluation().then(function () {
                        $state.go('main.myvideo.video-submit');
                    });
                }
            });
        };

        $scope.back = function() {
            if ($scope.videoSelected && $scope.infoUpdated) {
                openModal('modules/ui-components/modals/confirm-media-update/confirm-media-update_template.html', 'ConfirmMediaUpdateController', {headerText: 'Navigating away from video capture'});

                modalInstance.result.then(function (result) {
                    if (result.continue) {
                        if (originalVideo && originalVideo.id) {
                            $scope.evaluation.images[0] = originalVideo;
                        }
                        $state.go('main.myvideo.video-instructions');
                    }
                });
            } else {
                $state.go('main.myvideo.video-instructions');
            }
        };

        $scope.$watch('video.imageDescription', function (newVal, oldVal) {
            if (typeof oldVal === 'undefined' || (oldVal == newVal)) return;
            
            $scope.infoUpdated = true;
        });

        var openModal = function (template, controller, data) {
            var modalInfo = {value: null, dismissed: true, resendHash: []};
            modalInstance = $modal.open({
                windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
                templateUrl: template,
                controller: controller,
                backdrop: 'static',
                keyboard: false,
                resolve: {
                    modalInfo: function () {
                        return modalInfo;
                    },
                    params: function(){
                        return data;
                    }
                }
            });
        };
    });
});