define(['VideoInstructionsController'], function () {
    'use strict';

    describe('Video Instructions Controller', function () {
        var controller,
            scope,
            stateMock,
            videoServiceMock,
            mediaRequest = {},
            configServiceValues = {
                imageFileSizeLimit: 3,
                suggestedVideoSize: 10,
                videoFileSizeLimit: 20
            };
        
        beforeEach(function () {
            module('angularTemplateApp');

            stateMock = jasmine.createSpyObj('$state', ['go']);
            videoServiceMock = jasmine.createSpyObj('videoService', ['saveMediaRequest', 'saveEvaluation', 'setQuestionnaireResponseId', 'getMediaRequest']);

            videoServiceMock.saveEvaluation.and.returnValue({
				then: function (callback) {
					callback();
				}
            });
            
            videoServiceMock.getMediaRequest.and.callFake(function () {
                return mediaRequest;
            });

            module(function ($provide) {
                $provide.value('$state', stateMock);
                $provide.value('videoService', videoServiceMock);
                $provide.value('configServiceValues', configServiceValues);
            });

            inject(function ($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

        describe('continue function', function () {
            it ('should open the video upload page if saveMediaRequest is successful', function () {
                videoServiceMock.saveMediaRequest.and.returnValue({
                    then: function (callback) {
                        callback();
                    }
                });

                controller = controller('VideoInstructionsController', {$scope: scope});
                scope.continue();
                expect(stateMock.go).toHaveBeenCalledWith('main.myvideo.video-upload');
            });

            it ('should not open the video upload page if the saveMediaRequest is unsuccessful', function () {
                videoServiceMock.saveMediaRequest.and.returnValue({
                    then: function (callback) {
                        //empty success block
                    }
                });

                controller = controller('VideoInstructionsController', {$scope: scope});
                scope.continue();
                expect(stateMock.go).not.toHaveBeenCalled();
            });
        });

        describe('back function', function () {
            it ('should open the video media request details page', function () {
                controller = controller('VideoInstructionsController', {$scope: scope});
                scope.back();
                expect(stateMock.go).toHaveBeenCalledWith('main.myvideo.media-request-info');
            });
        });
    });
});