define(['angular', 'app'], function (angular, app) {
    'use strict';
    app.controller('VideoSubmitController', function ($scope, $controller, videoService, videoSubmitEvaluationService, $state) {
        $scope.infoText = 'After reviewing the information you submitted, the provider may need to contact you with follow up questions';

        $scope.submitCallback = function () {
            var mediaRequest = videoService.getMediaRequest();
            var evaluation = videoService.getEvaluation();

            mediaRequest.status = "SUBMITTED";
            evaluation.status = "COMPLETED";

            videoSubmitEvaluationService.reset();
            videoSubmitEvaluationService.submit();
        };

        $scope.previousCallback = function () {
            $state.go('main.myvideo.video-upload');
        };

        $scope.showProgressBar = false;

        angular.extend(this, $controller('SubmitController', {$scope: $scope}));
    });
});