define(['VideoSubmitController'], function() {
    'use strict';

    describe("The Video Submit Controller", function () {
        var controller,
            scope,
            videoServiceMock,
            videoSubmitEvaluationServiceMock,
            fhirPatientMock,
            stateMock,
            mediaRequest = {
                status: ''
            },
            evaluation = {
                status: ''
            };

        beforeEach(function () {
            module('angularTemplateApp');

            stateMock = jasmine.createSpyObj('$state', ['go']);
            videoServiceMock = jasmine.createSpyObj('videoService', ['getMediaRequest', 'getEvaluation']);
            videoSubmitEvaluationServiceMock = jasmine.createSpyObj('videoSubmitEvaluationService', ['reset', 'submit']);
            fhirPatientMock = jasmine.createSpyObj('fhirPatient', ['fetch']);

            videoServiceMock.getMediaRequest.and.callFake(function () {
                return mediaRequest;
            });

            videoServiceMock.getEvaluation.and.callFake(function () {
                return evaluation;
            });

            fhirPatientMock.fetch.and.returnValue({
                then: function () {}
            });

            module(function ($provide) {
                $provide.value('$state', stateMock);
                $provide.value('videoService', videoServiceMock);
                $provide.value('videoSubmitEvaluationService', videoSubmitEvaluationServiceMock);
                $provide.value('fhirPatient', fhirPatientMock);
            });

            inject(function($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

        describe("initial state", function () {
            it("should correctly set initial values", function () {
                controller = controller('VideoSubmitController', {$scope: scope});
                scope.$apply();

                expect(scope.showProgressBar).toBeFalsy();
                expect(scope.infoText).toEqual('After reviewing the information you submitted, the provider may need to contact you with follow up questions');
            });
        });

        describe("submitCallback", function () {
            var result;

            beforeEach(function () {
                controller = controller('VideoSubmitController', {$scope: scope});
                evaluation = {
                    status: 'STARTED'
                };

                mediaRequest = {
                    status: 'PENDING'
                };

                scope.submitCallback();
            });
            
            it("should update the evaluation status", function () {
                expect(evaluation).toEqual({
                    status: 'COMPLETED'
                });
            });

            it("should update the mediaRequest status", function () {
                expect(mediaRequest).toEqual({
                    status: 'SUBMITTED'
                });
            });

            it("should reset the submitEvaluation service", function () {
                expect(videoSubmitEvaluationServiceMock.reset).toHaveBeenCalled();
            });

            it("should submit the evaluation", function () {
                expect(videoSubmitEvaluationServiceMock.submit).toHaveBeenCalled();
            });
        });

        describe("previousCallback function", function () {
            it("should go to video instructions page", function () {
                controller = controller('VideoSubmitController', {$scope: scope});
                scope.previousCallback();

                expect(stateMock.go).toHaveBeenCalledWith('main.myvideo.video-upload');
            });
        });

        it("should extend the shared SubmitController", function () {
            controller = controller('VideoSubmitController', {$scope: scope});

            expect(scope.contactType).toEqual('email');
            expect(scope.contactInfo).toEqual({
                email: '',
                phone: ''
            });
        });
    });
});