define(['VideoRetryController'], function () {
    'use strict';

    describe("Video Retry Controller", function () {
        var controller,
            scope,
            focusServiceMock;

        beforeEach(function () {
            module('angularTemplateApp');

            focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);

            module(function ($provide) {
                $provide.value('videoSubmitEvaluationService', 'videoSubmitEvaluationService');
                $provide.value('$stateParams', {});
                $provide.value('focusService', focusServiceMock);
                $provide.value('globalDelayTracker', {});
            });

            inject(function ($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

        describe("initial status", function () {
            it("should set the submitEvaluationService", function () {
                controller = controller('VideoRetryController', {$scope: scope});

                expect(scope.submitEvaluationService).toEqual('videoSubmitEvaluationService');
            });
        });

        it("should extend the RetryController", function () {
            controller = controller('VideoRetryController', {$scope: scope});

            expect(scope.statusTemplate).toEqual('modules/applets/shared/pages/submit-status/retry/retry_template.html');
        });
    });
});