define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.controller('VideoRequestsController', function ($scope, $controller, $q, videoService, videoRequestsService) {
        $scope.imageIcon = 'glyphicon glyphicon-facetime-video';

        $scope.filterFormHeader = 'List of Video Requests';

		$scope.service =  videoRequestsService;
		$scope.requestType = videoRequestsService.requestType;

		$scope.table = {
			columns : [
				{label: "Dates", keys: "startDate", hyphenateAndAppendKeys: "endDate", reverse: true, isSortKey: true},
				{label: "Take a Video Of", reverse: false, isSortKey: false, keys: "requestReason", class: {column: "hidden-xs media-request-reason-col"}},
				{label: "Status", keys: "status", reverse: false, isSortKey: false}
			]
		};

        $scope.selectEvalCallback = function(mediaRequest) {
            return videoService.setMediaRequest(mediaRequest);
		};
		
		$scope.routeBase = 'main.myvideo.media-request';

        angular.extend(this, $controller('MediaRequestsController', {$scope: $scope}));
    });
});
