define(['VideoRequestsController'], function() {
	'use strict';

	describe("The Video Requests Controller", function () {
		var controller,
			scope,
			globalDelayTrackerMock,
			videoRequestsServiceMock,
			focusServiceMock;

		beforeEach(function () {
			module('angularTemplateApp');

			globalDelayTrackerMock = jasmine.createSpyObj('globalDelayTracker', ['active']);
			videoRequestsServiceMock = jasmine.createSpyObj('videoRequestsService', ['fetch','sort']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);

			videoRequestsServiceMock.fetch.and.callFake(function () {
				scope.service.dataPointers =
				{
					list: [],
					filters: [],
					unfilteredItemCount: 0
				};
				scope.service.config =
				{
					collection: {
						objectType: "MediaRequests",
						name: "requests",
						sortComparator: [{key: "startDate", reverse: true}]
					}
				};
				return "";
			});

			module(function ($provide) {
				$provide.value('globalDelayTracker', globalDelayTrackerMock);
				$provide.value('videoRequestsService', videoRequestsServiceMock);
				$provide.value('videoService', {});
				$provide.value('focusService', focusServiceMock);
			});

			inject(function($controller, $rootScope) {
				scope = $rootScope.$new();
				scope.service = videoRequestsServiceMock;
				scope.service.fetch();
				controller = $controller;
			});
		});

		describe("setting the table", function () {
			it("should have table defined", function () {
				controller = controller('VideoRequestsController', {$scope: scope});
				scope.$apply();
				expect(scope.table).toBeDefined();
				expect(scope.table.columns).toBeDefined();
				expect(scope.table.columns.length).toEqual(3);
				expect(scope.table.columns[0].keys).toBeDefined();
				expect(scope.table.columns[0].label).toBeDefined();
				expect(scope.table.columns[0].reverse).toBeDefined();
				expect(scope.table.columns[0].isSortKey).toBeDefined();
				expect(scope.table.columns[1].class).toBeDefined();
				expect(scope.table.columns[1].class.column).toBeDefined();

				expect(scope.table.columns[0].keys).toEqual('startDate');
				expect(scope.table.columns[0].label).toEqual('Dates');
				expect(scope.table.columns[0].hyphenateAndAppendKeys).toEqual('endDate');
				expect(scope.table.columns[1].keys).toEqual('requestReason');
				expect(scope.table.columns[1].label).toEqual('Take a Video Of');
				expect(scope.table.columns[2].keys).toEqual('status');
				expect(scope.table.columns[2].label).toEqual('Status');
			});
		});

		describe("myvideo image icon", function () {
			it("should have image icon class set", function () {
				controller = controller('VideoRequestsController', {$scope: scope});
				scope.$apply();
				expect(scope.imageIcon).toEqual('glyphicon glyphicon-facetime-video');
			});
		});

		describe("myvideo route", function () {
			it("should have route base set", function () {
				controller = controller('VideoRequestsController', {$scope: scope});
				scope.$apply();
				expect(scope.routeBase).toEqual('main.myvideo.media-request');
			});
		});

	});
});