define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.controller('VideoRequestInfoController', function ($scope, $state, $modal, videoService, $controller) {
        $scope.mediaRequest = videoService.getMediaRequest();
        $scope.evaluation = videoService.getEvaluation();
        $scope.continueText = 'Continue';
        $scope.viewSubmittedText = 'View Submitted Videos';
        $scope.requestInfoTemplate = "modules/applets/myvideo/pages/media-request-info/partials/_myvideo-request-info.html";
		$scope.routeBase = 'main.myvideo';

        $scope.continueCallback = function () {
            $state.go('main.myvideo.video-instructions');
        };

        $scope.reviewCallback = function (event) {
            var modalInfo = {value: null, dismissed: true, resendHash: []};
			var modalInstance;
			var controller;
			var returnFocusElement = event.currentTarget;
			modalInstance = $modal.open({
				windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
				templateUrl: 'modules/ui-components/modals/view-video/view-video_template.html',
				controller: 'ViewVideoController',
				backdrop: 'static',
				keyboard: false,
				resolve: {
					modalInfo: function () {
						return modalInfo;
					},
					mediaRequest: function () {
						return $scope.mediaRequest;
					},
					evaluation: function () {
						return $scope.evaluation;
					},
					returnFocusElement: function () {
						return returnFocusElement;
					}
				}
			});
		};
		
		angular.extend(this, $controller('MediaRequestInfoController', {$scope: $scope}));
    });
});