define(['VideoRequestInfoController'], function () {
    'use strict';

    describe("VideoRequestInfoController", function () {
        var controller,
            scope,
            videoServiceMock,
            stateMock,
            modalMock,
            eventMock,
            mediaRequest = {
                providerContacts: [],
                mediaTypes: []
            },
            evaluation = {};

        beforeEach(function () {
            module('angularTemplateApp');
            
            videoServiceMock = jasmine.createSpyObj('videoService', ['getMediaRequest', 'getEvaluation']);
            stateMock = jasmine.createSpyObj('$state', ['go']);
            modalMock = jasmine.createSpyObj('$modal', ['open']);
            eventMock = {
                currentTarget: {}
            };


            videoServiceMock.getMediaRequest.and.callFake(function () {
                return mediaRequest;
            });

            videoServiceMock.getEvaluation.and.callFake(function () {
                return evaluation;
            });

            module(function ($provide) {
                $provide.value('videoService', videoServiceMock);
                $provide.value('$state', stateMock);
                $provide.value('$modal', modalMock);
            });

            inject(function ($controller, $rootScope, $modal) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

        describe("Initial state", function () {
            beforeEach(function () {
                controller = controller('VideoRequestInfoController', {$scope: scope});
            });

            it("should correctly set initial values", function () {
                scope.$apply();

                expect(scope.continueText).toEqual('Continue');
                expect(scope.viewSubmittedText).toEqual('View Submitted Videos');
                expect(scope.routeBase).toEqual('main.myvideo');
                expect(scope.requestInfoTemplate).toEqual('modules/applets/myvideo/pages/media-request-info/partials/_myvideo-request-info.html');
                expect(scope.mediaRequest).toBeDefined();
            });
        });

        describe('continueCallback function', function () {
            it ('should go to the next page video-instructions', function () {
                controller = controller('VideoRequestInfoController', {$scope: scope});
                scope.continueCallback();
                expect(stateMock.go).toHaveBeenCalledWith('main.myvideo.video-instructions');
            });
        });

        describe('reviewCallback function', function () {
            it ('should open the view video page', function () {
                controller = controller('VideoRequestInfoController', {$scope: scope});
                scope.reviewCallback(eventMock);
                expect(modalMock.open).toHaveBeenCalled();
            });
        });
    });
});