define([
    'app',
    'videoSubmitStatusValue',
    'VideoRequestsController',
    'VideoRequestInfoController',
    'VideoInstructionsController',
    'VideoUploadController',
    'VideoSubmitController',
    'VideoRetryController',
    'videoRequestsService',
    'videoService',
    'videoUploadService',
    'videoSubmitEvaluationService',
    'configValuesService'
], function (app, videoSubmitStatusValue) {
	'use strict';

	app.config(function ($stateProvider) {
		$stateProvider
            .state('main.myvideo', {
                url: '/myvideo',
                appNavIndex: 3,
                data:{
                    appletName: "My Video"
                },
                views: {
                    "": {
                        templateUrl: 'modules/container/components/content/single-column_template.html'
                    },
                    'primary@main.myvideo': {
                        templateUrl: 'modules/applets/shared/pages/media-requests/media-requests_template.html',
                        controller: 'VideoRequestsController'
                    }
                }
            })
            .state('main.myvideo.media-request-info', {
				views: {
                    'primary@main.myvideo': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'SubheaderController'
                    },
                    'content@main.myvideo.media-request-info': {
                        templateUrl: 'modules/applets/shared/pages/media-request-info/media-request-info_template.html',
                        controller: 'VideoRequestInfoController'
                    }
                },
                params: { 
                    subtitle: 'Video Request Details'
                }
            })
            .state('main.myvideo.video-instructions', {
				views: {
                    'primary@main.myvideo': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'SubheaderController'
                    },
                    'content@main.myvideo.video-instructions': {
                        templateUrl: 'modules/applets/myvideo/pages/video-instructions/video-instructions_template.html',
                        controller: 'VideoInstructionsController'
                    }
                },
                params: { 
                    subtitle: 'Video Request Details'
                },
                resolve: {
                    configServiceValues: function (configValuesService) {
                        return configValuesService.fetch('file-size-limits');
                    }
                }
            })
            .state('main.myvideo.video-upload', {
				views: {
                    'primary@main.myvideo': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'SubheaderController'
                    },
                    'content@main.myvideo.video-upload': {
                        templateUrl: 'modules/applets/myvideo/pages/video-upload/video-upload_template.html',
                        controller: 'VideoUploadController'
                    }
                },
                params: { 
                    subtitle: 'Video Request Details'
                },
                resolve: {
                    configServiceValues: function (configValuesService) {
                        return configValuesService.fetch('file-size-limits');
                    }
                }
            })
            .state('main.myvideo.video-submit', {
				views: {
                    'primary@main.myvideo': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'SubheaderController'
                    },
                    'content@main.myvideo.video-submit': {
                        templateUrl: 'modules/applets/shared/pages/submit/submit_template.html',
                        controller: 'VideoSubmitController'
                    }
                },
                params: { 
                    subtitle: 'Video Request Details'
                }
            })
            .state('main.myvideo.success', {
                views: {
                    'primary@main.myvideo': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'SuccessController'
                    },
                    'content@main.myvideo.success': {
                        templateUrl: 'modules/applets/shared/pages/submit-status/submit-status_template.html'
                    }
                },
                params: videoSubmitStatusValue
            })
            .state('main.myvideo.retry', {
                views: {
                    'primary@main.myvideo': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'VideoRetryController'
                    },
                    'content@main.myvideo.retry': {
                        templateUrl: 'modules/applets/shared/pages/submit-status/submit-status_template.html'
                    }
                },
                params: videoSubmitStatusValue
            })
            .state('main.myvideo.failed', {
                views: {
                    'primary@main.myvideo': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'FailedController'
                    },
                    'content@main.myvideo.failed': {
                        templateUrl: 'modules/applets/shared/pages/submit-status/submit-status_template.html'
                    }
                },
                params: angular.extend({
                    providerType: 'Provider'
                }, videoSubmitStatusValue)
            });;
	});
});