define(['angular', 'app'], function (angular, app) {
	'use strict';

	app.service('teledermSubmitEvaluationService', function ($q, submitEvaluationService, imageMediaRequestService, imageResponseService) {
		var service = {
			successRoute: 'main.mytelederm.success',
			retryRoute: 'main.mytelederm.retry',
			failedRoute: 'main.mytelederm.failed',
			submitFunction: function () {
				var deferred = $q.defer();
				imageResponseService.saveEvaluation().then(function () {
					imageMediaRequestService.saveMediaRequest().then(function () {
						deferred.resolve();
					}, function () {
						deferred.reject();
					});
				}, function () {
					deferred.reject();
				});
				return deferred.promise;
			}
		};

		angular.extend(service, submitEvaluationService);

		return service;
	});
});