define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('mediaRequestProgressService', function (imageMediaRequestService, imageResponseService) {
        return {
            getNumCompleted: function () {
                var evaluation = imageResponseService.getEvaluation();
                var numCompleted = 0;

                //check Skin Status
                if (evaluation.skinStatus) {
                    numCompleted++;
                }

                //check MedTypes
                if (this.isMedTypesComplete()) {
                    numCompleted++;
                }

                //check Medications
                numCompleted += this.getCompletedMedsSteps();

                //check additional comments
                if (evaluation.additionalComments) {
                    numCompleted++;
                }

                //check responses accepted
                if (evaluation.isResponsesAccepted) {
                    numCompleted++;
                }

                //check photo pages
                numCompleted += this.getCompletedPhotoSteps();

                return numCompleted;
            },
            isMedTypesComplete: function () {
                var evaluation = imageResponseService.getEvaluation();
                var otherSelected = evaluation.medicationTypes.indexOf("OTHER") !== -1;
                var noMedTypes = !evaluation.medicationTypes.length && evaluation.otherMedication === "N/A";

                return noMedTypes || (evaluation.medicationTypes.length && (!otherSelected || (otherSelected && evaluation.otherMedication)));
            },
            getCompletedMedsSteps: function () {
                var that = this;
                var evaluation = imageResponseService.getEvaluation();
                var numCompleted = 0;

                var meds = [];
                if (evaluation.medications) {
                    meds = meds.concat(evaluation.medications);
                }

                evaluation.medicationTypes.forEach(function (medType) {
                    var medGroup = _.filter(meds, function (med) {
                        return med.type === medType;
                    });

                    if (medGroup.length && !_.filter(medGroup, function (med) {
                        return that.isMedIncomplete(med);
                    }).length) {
                        numCompleted++;
                    }
                });

                return numCompleted;
            },
            isMedIncomplete: function (med) {
                return !med.name || (!med.numDosesPerTimeUnit && med.numDosesPerTimeUnit !== 0) || !med.timeUnit || (!med.missedDoses && med.missedDoses !== 0);
            },
            getCompletedPhotoSteps: function () {
                var evaluation = imageResponseService.getEvaluation();
                var sections = imageMediaRequestService.getImageTypesBySection();
                var sectionNames = Object.keys(sections);

                var imageSections = imageResponseService.getUploadedImagesBySection();
                var optionalPhotos = imageSections['OPTIONAL'] || [];
                var numCompleted = 0;

                sectionNames.forEach(function (sectionName) {
                    var imageSection = imageSections[sectionName] || {};
                    var required = imageSection['PRIMARY'] || [];
                    var closeUps = imageSection['CLOSE_UP'] || [];

                    numCompleted += required.length;
                    
                    if (closeUps.length) {
                        numCompleted++;
                    }
                });

                if (evaluation.isOptionalImages === false || (evaluation.isOptionalImages && optionalPhotos.length)) {
                    numCompleted++;
                }

                return numCompleted;
            },
            getTotalSteps: function () {
                var mediaRequest = imageMediaRequestService.getMediaRequest();
                var evaluation = imageResponseService.getEvaluation();
                var guaranteedSteps = 4; //Skin Status & Med Types & Comments & Review Answers
                var imageTypes = mediaRequest.mediaTypes || [];

                var sectionNames = Object.keys(imageMediaRequestService.getImageTypesBySection());

                var numPhotoSteps = imageTypes.length + sectionNames.length + 1; //each photo + AT LEAST 1 close up FOR EACH SECTION, + optional pictures

                var numMedTypes = _.filter(evaluation.medicationTypes, function (medType) {
                    return medType !== 'OTHER';
                }).length;
                
                return guaranteedSteps + numMedTypes + numPhotoSteps;
            }
        };
    });
});