define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('mediaRequestNavigationService', function ($state, $stateParams, imageMediaRequestService, imageResponseService, medicationTypes) {
        var pages = [];

        return {
			getPagesList: function () {
                return pages;
            },
			getPage: function (pageNumber) {
				return pages[pageNumber];
			},
            previousPage: function (saveEval) {
                saveEval = (typeof saveEval === 'undefined') ? true : saveEval;
                var evaluation = imageResponseService.getEvaluation();
                var that = this;

                this.generateListOfPages();
                this.resetPageNumber();

				var pageToSave = this.getPage(evaluation.pageNumber);

                if (evaluation.pageNumber > 0) {
                    evaluation.pageNumber--;

                    if (saveEval) {
                        imageResponseService.saveEvaluation(pageToSave).then(function () {
                            that.goToPage(evaluation.pageNumber);
                        });
                    } else {
                        that.goToPage(evaluation.pageNumber);
                    }
                }
            },
            nextPage: function (saveRequest) {
                saveRequest = (typeof saveRequest === 'undefined') ? true : saveRequest;
                var evaluation = imageResponseService.getEvaluation();
                var that = this;

                this.generateListOfPages();
                this.resetPageNumber();

				var pageToSave = this.getPage(evaluation.pageNumber);
				
                if (evaluation.pageNumber < pages.length - 1) {
					evaluation.pageNumber++;

                    if (saveRequest) {
                        imageResponseService.saveEvaluation(pageToSave).then(function (responseId) {
							if(!imageMediaRequestService.getMediaRequest().questionnaireResponse){
								imageMediaRequestService.setQuestionnaireResponseId(responseId);
								imageMediaRequestService.saveMediaRequest().then(function () {
									that.goToPage(evaluation.pageNumber);
								});
							} else {
								that.goToPage(evaluation.pageNumber);
							}
                        });
                    }
                    else {
                        that.goToPage(evaluation.pageNumber);
                    }
                }
            },
            skipToNextSection: function () {
                this.skipToRoute('main.mytelederm.photo-input', 'main.mytelederm.take-another-picture','main.mytelederm.photo-input-optional');
            },
            skipToReviewPhotos: function () {
                this.skipToRoute('main.mytelederm.review-photos');
            },
            skipToRoute: function () {
                var evaluation = imageResponseService.getEvaluation();
                var that = this;
                var args = this.buildArrayFromArgs(arguments);
                this.generateListOfPages();
				var pageToSave = this.getPage(evaluation.pageNumber);

                for (var i = evaluation.pageNumber + 1; i < pages.length; i++) {
                    var route = pages[i].route;
                    var newPageNumber;

                    args.forEach(function (arg) {
                        if (route === arg) {
                            newPageNumber = i;
                        }
                    });

                    if (newPageNumber) {
                        evaluation.pageNumber = newPageNumber;
                        break;
                    }
                }

                imageResponseService.saveEvaluation(pageToSave).then(function () {
                    that.goToPage(evaluation.pageNumber);
                });
            },
            buildArrayFromArgs: function (args) {
                args = args || [];

                var newArray = [];
    
                for (var i = 0; i < args.length; i++) {
                    newArray.push(args[i]);
                }
    
                return newArray;
            },
            resume: function () {
                this.generateListOfPages();

                this.goToPage(imageResponseService.getEvaluation().pageNumber);
            },
            generateListOfPages: function () {
                pages = [];
                pages = pages.concat(
                    [
                        {
                            route: 'main.mytelederm.skin-status'
                        },
                        {
                            route: 'main.mytelederm.medications'
                        }
                    ],
                    this.generateMedicationEntryPages(),
                    [
                        {
                            route: 'main.mytelederm.additional-comments'
                        },
                        {
                            route: 'main.mytelederm.response-summary'
                        },
                        {
                            route: 'main.mytelederm.photo-instructions'
                        }
                    ],
                    this.generatePhotoInputPages(),
                    this.generateOptionalPhotoPages(),
                    [
                        {
                            route: 'main.mytelederm.review-photos'
                        },
                        {
                            route: 'main.mytelederm.submit'
                        }
                    ]
                );
            },
            generateMedicationEntryPages: function () {
                var evaluation = imageResponseService.getEvaluation();
                var medicationEntryPages = [];

                medicationTypes.forEach(function (medType) {
                    if (evaluation.medicationTypes.indexOf(medType) !== -1) {
                        medicationEntryPages.push({
                            route: 'main.mytelederm.medications-entry',
                            params: {
                                medType: medType
                            }
                        });
                    }
                });

                return medicationEntryPages;
            },
            generatePhotoInputPages: function () {
                var imageTypesBySection = imageMediaRequestService.getImageTypesBySection();
                var imageSectionsMap = imageMediaRequestService.getImageSectionsMap();
                var uploadedImagesBySection = imageResponseService.getUploadedImagesBySection();
                var photoInputPages = [];

                Object.keys(imageTypesBySection).forEach(function (imageSectionName) {
                    var imagesInSection = imageTypesBySection[imageSectionName];
                    var imageSection = imageSectionsMap[imageSectionName.split('_')[0]];
                    imagesInSection.forEach(function (imageType, i) {
                        photoInputPages.push({
                            route: 'main.mytelederm.photo-input',
                            params: {
                                imageSection: imageSection,
                                imageType: imageType,
                                imageNum: i + 1,
                                totalImagesInSection: imagesInSection.length
                            }
                        });
                    });

                    var uploadedCloseUps = uploadedImagesBySection[imageSectionName]['CLOSE_UP'];
                    var numCloseUps = uploadedCloseUps.length || 1;

                    for (var i = 0; i < numCloseUps; i++) {
                        photoInputPages.push({
                            route: 'main.mytelederm.photo-input-close-up',
                            params: {
                                imageSection: imageSection,
                                imageNum: i + 1
                            }
                        });
                    }
                });

                return photoInputPages;
            },
            generateOptionalPhotoPages: function () {
                var uploadedImagesBySection = imageResponseService.getUploadedImagesBySection();
                var uploadedOptionalImages = uploadedImagesBySection['OPTIONAL'] || [];
                var evaluation = imageResponseService.getEvaluation();
                var numOptionalPages = !evaluation.isOptionalImages ? 0 : uploadedOptionalImages.length || 1;
                var optionalPages = [];


				if(uploadedOptionalImages.length < 1) {
					optionalPages = [
						{
							route: 'main.mytelederm.take-another-picture'
						}
					];
				}

				for (var i = 0; i < numOptionalPages; i++) {
					optionalPages.push({
						route: 'main.mytelederm.photo-input-optional',
						params: {
							imageNum: i + 1
						}
					});
				}


                return optionalPages;
            },
            goToPage: function (pageNumber) {
                $state.go(pages[pageNumber].route, pages[pageNumber].params);
            },
            resetPageNumber: function () {
                var evaluation = imageResponseService.getEvaluation();
                var newPageNumber = _.findIndex(pages, function (page) {
                    var route = page.route;
                    var params = page.params;

                    return route === $state.current.name && (!params || _.isEqual($stateParams, params));
                });

                evaluation.pageNumber = newPageNumber !== -1 ? newPageNumber : evaluation.pageNumber;
				imageResponseService.setEvaluation(evaluation);
            }
        };
    });
});