define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('imageUploadService', function ($q, $http, fhirResources, imageResponseService) {
        return {
            uploadImage: function (file, data, saveEval) {
                saveEval = (typeof saveEval === 'undefined') ? true : saveEval;

                var deferred = $q.defer();
				var that = this;
				var image = data;
				var params = this.getParams(data);
				var route = this.getRoute(data.imageClass);

				var evaluation = imageResponseService.getEvaluation(),
					method = data.id ? 'PUT' : 'POST',
					resourceName = data.id? 'Media/' + data.id : 'Media',
					media = that.createMedia(data.id, evaluation.mediaRequestId, file);


				that.getBase64(file).then(function(data) {
					media.content.data = data.replace("data:" + file.type + ";base64,", "");

					var resourceConfig = {
						method: method,
						resourceName: resourceName,
						data: media
					};

					fhirResources.createUpdateFhirResource(resourceConfig).then(
						function (response) {
							image.id = response.split("/")[1];
							image.imageUrl = fhirResources.getFhirBaseUrl() + "/" + response;

							imageResponseService.setMedia(image);

							if (saveEval) {
								imageResponseService.saveEvaluation({
									route: route,
									params: params
								}).then(function () {
									deferred.resolve();
								});
							} else {
								deferred.resolve();
							}
						},
						function (error) {
							deferred.reject(error);
						}
					);
				});


				return deferred.promise;
            },
			createMedia: function(imageId, mediaRequestId, file) {
				var response = {
					resourceType: 'Media',
					type: 'photo',
					identifier: [{value: mediaRequestId}],
					subject: {reference: 'Patient/' + imageResponseService.getPatient().id},
					content: {
						data: '',
						contentType: file.type,
						size: file.size,
						title: file.name
					}
				};

				if(imageId)
					response.id = imageId;

				return response;
			},
			getBase64: function(file) {
				var deferred = $q.defer();
				var reader = new FileReader();
				reader.onload = function () {
					deferred.resolve(reader.result);
				};
				reader.onerror = function (error) {
					deferred.reject();
				};
				reader.readAsDataURL(file);

				return deferred.promise;
			},
			getRoute: function (imageClass) {
				var route = '';
				switch(imageClass) {
					case "PRIMARY" : {route = "photo-input"; break;}
					case "CLOSE_UP" : {route = 'photo-input-close-up'; break;}
					case "OPTIONAL" : {route = 'photo-input-optional'; break;}
				}
				return route;
			},
			getParams: function (imageData) {
				var params = {
					imageNum: imageData.imageNumber || 0,
					imageSection : imageData.imageSection,
					imageType: imageData.imageType}
				return params;
			}
        };
    });
});