define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('imageRotationService', function ($q) {
        return {
            // Function courtesy: https://stackoverflow.com/questions/7584794/accessing-jpeg-exif-rotation-data-in-javascript-on-the-client-side
            // This specific function has not been unit tested, but the expected results are unit tested with getRotateClass
            getOrientation: function (file, callback) {
                var reader = new FileReader();
                reader.onload = function (e) {

                    var view = new DataView(e.target.result);
                    if (view.getUint16(0, false) != 0xFFD8) return callback(-2);
                    var length = view.byteLength, offset = 2;
                    while (offset < length) {
                        var marker = view.getUint16(offset, false);
                        offset += 2;
                        if (marker == 0xFFE1) {
                            if (view.getUint32(offset += 2, false) != 0x45786966) return callback(-1);
                            var little = view.getUint16(offset += 6, false) == 0x4949;
                            offset += view.getUint32(offset + 4, little);
                            var tags = view.getUint16(offset, little);
                            offset += 2;
                            for (var i = 0; i < tags; i++)
                                if (view.getUint16(offset + (i * 12), little) == 0x0112)
                                    return callback(view.getUint16(offset + (i * 12) + 8, little));
                        }
                        else if ((marker & 0xFF00) != 0xFF00) break;
                        else offset += view.getUint16(offset, false);
                    }
                    return callback(-1);
                };
                reader.readAsArrayBuffer(file);
            },
            getRotateClass: function (file) {
                var deferred = $q.defer();

                this.getOrientation(file, function (orientation) {
                    var rotateClass = '';

                    switch (orientation) {
                        case 3:
                            rotateClass = 'rotate-180';
                            break;
                        case 6:
                            rotateClass = 'rotate-90-right';
                            break;
                        case 8:
                            rotateClass = 'rotate-90-left';
                            break;
                    };

                    deferred.resolve(rotateClass);
                });

                return deferred.promise;
            }
        }
    });
});