define(['imageRotationService'], function () {
    'use strict';

    describe("Image Rotation Service", function () {
        var service,
            qMock,
            deferredMock;
        
        beforeEach(function () {
            module('angularTemplateApp');

            qMock = jasmine.createSpyObj('$q', ['defer']);
            deferredMock = jasmine.createSpyObj('deferred', ['resolve']);

            deferredMock.promise = 'This is a promise';

            qMock.defer.and.returnValue(deferredMock);

            module(function ($provide) {
                $provide.value('$q', qMock);
            });

            inject(function (imageRotationService) {
                service = imageRotationService;
            });
        });

        describe("getRotateClass", function () {
            var orientation;

            beforeEach(function () {
                spyOn(service, 'getOrientation').and.callFake(function (file, callback) {
                    callback(orientation);
                });
            });

            it("should return a promise", function () {
                expect(service.getRotateClass()).toEqual('This is a promise');
            });

            it("should call getOrientation with the given file", function () {
                service.getRotateClass('image-blob');

                expect(service.getOrientation.calls.argsFor(0)[0]).toEqual('image-blob');
            });

            it("should resolve to an empty string if the orientation is not recognized", function () {
                orientation = -1;

                service.getRotateClass('image-blob');

                expect(deferredMock.resolve).toHaveBeenCalledWith('');
            });

            it("should resolve to 'rotate-180' if the orientation is 3", function () {
                orientation = 3;

                service.getRotateClass('image-blob');

                expect(deferredMock.resolve).toHaveBeenCalledWith('rotate-180');
            });

            it("should resolve to 'rotate-90-right' if the orientation is 6", function () {
                orientation = 6;

                service.getRotateClass('image-blob');

                expect(deferredMock.resolve).toHaveBeenCalledWith('rotate-90-right');
            });

            it("should resolve to 'rotate-90-left' if the orientation is 8", function () {
                orientation = 8;

                service.getRotateClass('image-blob');

                expect(deferredMock.resolve).toHaveBeenCalledWith('rotate-90-left');
            });
        });
    });
});