define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('imageResponseService', function ($http, $q, questionnaireResponseService, medicationTypes) {

		var imageTypesBySection = {};
		var imageSectionsMap = {};
		var uploadedImagesBySection = {};
		var hasDeletedCloseups = false;
		var hasDeletedOptionals = false;

		var service =  {
			setImageTypesBySection: function (imageTypesBySectionMap) {
				imageTypesBySection = imageTypesBySectionMap;
			},
			setImageSectionsMap: function (imageSectionMap) {
				imageSectionsMap = imageSectionMap;
			},
			getUploadedImagesBySection: function () {
				return uploadedImagesBySection;
			},
			transformResponse: function (response) {
				var evaluation = {};
				var optionalImgs = this.findElement(response, this.getLinkId("MEDIA_OPTIONAL"));
				var status = _.get(response, "status") ||  "NOT_STARTED";
				evaluation.mediaRequestId = _.get(response, "identifier.value") ||  "";
				evaluation.status = status === 'in-progress' ? 'STARTED' :  status.toUpperCase();
				evaluation.skinStatus = this.getValue(response, this.getLinkId("SKIN_STATUS") + ".1") || "";
				evaluation.skinStatusComment = this.getValue(response, this.getLinkId("SKIN_STATUS") + ".2") || "";
				evaluation.medicationTypes = this.getMedicationTypes(response) || [];
				evaluation.otherMedication = this.getValue(response, this.getLinkId("OTHER_MEDICATIONS") + ".1") || "";
				evaluation.additionalComments = this.getValue(response, this.getLinkId("ADDITIONAL_COMMENTS") + ".1") || "";
				evaluation.isResponsesAccepted = this.getValue(response, this.getLinkId("RESPONSE_SUMMARY") + ".1") || false;
				evaluation.medications = this.getMedications(response) || [];
				evaluation.images = this.getImages(response) || [];
				evaluation.isOptionalImages = optionalImgs ? (optionalImgs.group ? true : false): null;
				evaluation.pageNumber = 0;

				if(evaluation.otherMedication === 'N/A')
					evaluation.medicationTypes.splice(evaluation.medicationTypes.indexOf('OTHER'),1);

				return evaluation;
			},
			updateResponse: function (page) {
				var pagesList = this.currResponse.group.group;
				var pageName = page && page.route.replace('main.mytelederm.', '') || '';
				var params = page && page.params || '';
				switch (pageName) {
					case "skin-status":
					case "additional-comments":
					case "response-summary": {
						pagesList = this.updatePage(pageName);
						break;
					}
					case "medications":
					case "medications-entry": {
						var that = this;
						if (params && params.medType) {
							pagesList = that.updatePage(params.medType + "_MEDICATIONS");
						}
						else {
							var medTypes = medicationTypes.concat(['OTHER']);
							medTypes.forEach(function (medType) {
								var grpName = medType + "_MEDICATIONS";
								var linkId = that.getLinkId(grpName);
								var pageIndex = _.findIndex(pagesList, {linkId: linkId});

								if (pageIndex >= 0 && that.currEvaluation.medicationTypes.indexOf(medType) < 0 && medType !== 'OTHER') {
									pagesList.splice(pageIndex, 1);
								}
								else if (that.currEvaluation.medicationTypes.indexOf(medType) >= 0 || medType === 'OTHER') {
									pagesList = that.updatePage(grpName);
								}
							});
						}

						break;
					}
					case "photo-input":
					case "photo-input-close-up": {
						var imageType = (!params.imageType || typeof(params.imageType.name) === 'undefined' ||  params.imageType.name === 'CLOSE_UP') ? params.imageSection.name + "_CLOSEUP" + params.imageNum : params.imageType.name;
						var sectionLinkId = this.getLinkId(params.imageSection.name);
						var typeLinkId = this.getLinkId(imageType);
						var pageIndex = _.findIndex(pagesList, {linkId: this.getLinkId("MEDIA")});
						if (pageIndex === -1) {
							pagesList.push(this.createImageGroup(params.imageSection.name,  imageType, sectionLinkId, typeLinkId));
						} else {
							//IMAGE SECTION
							var imageSectionList = pagesList[pageIndex].group || [];
							var sectionIndex = _.findIndex(imageSectionList, {linkId: sectionLinkId});
							if (sectionIndex === -1) {
								var subgroup = this.createImageSectionGroup(params.imageSection.name, imageType, sectionLinkId, typeLinkId);
								if (subgroup) imageSectionList.push(subgroup);
								pagesList[pageIndex].group = imageSectionList;
								break;
							}

							//IMAGE TYPE
							var imageTypeList = imageSectionList[sectionIndex].group || [];
							var typeIndex = _.findIndex(imageTypeList, {linkId: typeLinkId});
							var group = this.updateImageTypeGroup(params.imageSection.name, imageType, params.imageNum, typeLinkId);
							if (group && typeIndex >= 0) {
								imageTypeList[typeIndex] = group;
							} else if (group) {
								imageTypeList.push(group);
							}

							imageSectionList[sectionIndex].group = imageTypeList;
							pagesList[pageIndex].group = imageSectionList;
						}

						break;
					}
					case "take-another-picture":
					case "photo-input-optional": {
						var linkId = this.getLinkId("MEDIA_OPTIONAL");
						var pageIndex = _.findIndex(pagesList, {linkId: linkId});
						if (pageIndex === -1) {
							pagesList.push(this.createOptionalImageGroup());
						} else {
							if (!pagesList[pageIndex].group) {
								pagesList[pageIndex] = this.createOptionalImageGroup();
							}

							var optionalImagesList = pagesList[pageIndex].group || [];
							var imgIndex = _.findIndex(optionalImagesList, {linkId: linkId + "." + params.imageNum});
							var group = this.updateImageTypeGroup("OPTIONAL", "OPTIONAL", params.imageNum, linkId + "." + params.imageNum);
							if (group && imgIndex >= 0) {
								optionalImagesList[imgIndex] = group;
							} else if (group) {
								optionalImagesList.push(group);
							}

							pagesList[pageIndex].group = optionalImagesList;
						}
						break;
					}
					case "review-photos": {
						if (hasDeletedCloseups) {
							var that = this;
							var pageIndex = _.findIndex(pagesList, {linkId: this.getLinkId("MEDIA")});
							var deletedCloseups = _.filter(that.currEvaluation.images, {imageClass: 'CLOSE_UP', deleteImage: true});
							deletedCloseups.forEach(function (image) {
								var sectionLinkId = that.getLinkId(image.imageSection.name);
								var sectionIndex = _.findIndex(pagesList[pageIndex].group || [], {linkId: sectionLinkId});
								var group = that.refreshImageSectionGroup(image.imageSection.name, sectionLinkId);
								pagesList[pageIndex].group[sectionIndex] = group;
							});
						}

						if (hasDeletedOptionals) {
							var pageIndex = _.findIndex(pagesList, {linkId: this.getLinkId("MEDIA_OPTIONAL")});
							var group = this.refreshOptionalImagesGroup();
							pagesList[pageIndex].group = group;
						}
						break;
					}
				}
				this.currResponse.group.group = pagesList;
			},
			updatePage: function (pageName) {
				var grpName = pageName.replace('-','_').toUpperCase();
				var linkId = this.getLinkId(grpName);
				var pageIndex = _.findIndex(this.currResponse.group.group, { linkId : linkId});
				var pagesList = this.currResponse.group.group;
				var group = {};
				switch (grpName) {
					case "SKIN_STATUS": {
						group = this.createSkinStatusGroup(linkId);
						break;
					}
					case "ADDITIONAL_COMMENTS": {
						group = this.createAdditionalCommentsGroup(linkId);
						break;
					}
					case "RESPONSE_SUMMARY":{
						group = this.createResponseSummaryGroup(linkId);
						break;
					}
					case "TOPICAL_MEDICATIONS":
					case "ORAL_MEDICATIONS":
					case "INJECTED_MEDICATIONS": {
						group = this.createMedicationGroup(grpName.replace('_MEDICATIONS',''), linkId);
						break;
					}
					case "OTHER_MEDICATIONS": {
						group = this.createOtherMedicationsGroup(linkId);
						break;
					}
				}
				if (pageIndex < 0) {
					pagesList.push(group);
				} else {
					pagesList[pageIndex] = group;
				}

				return pagesList;
			},
			createSkinStatusGroup: function (linkId) {
				var group = {
					linkId: linkId,
					question: []
				};

				var skinStatusTypes = ["BETTER", "UNCHANGED", "WORSE"];

				group.question.push(this.createAnswer(linkId + ".1", "choice",this.currEvaluation.skinStatus, skinStatusTypes.indexOf(this.currEvaluation.skinStatus)));
				if (this.currEvaluation.skinStatusComment) {
					group.question.push(this.createAnswer(linkId + ".2", "string",this.currEvaluation.skinStatusComment));
				}

				return group;
			},
			createMedicationGroup : function (medType, linkId) {
				var group = {
					linkId: linkId,
					group: []
				};

				medType = medType.toUpperCase();
				var meds = _.filter(this.currEvaluation.medications, function (med) {
					return med.type === medType;
				});

				for (var i = 0; i < meds.length; i++) {
					group.group.push(this.createMedicationSubGroup(linkId, i+1, meds[i]));
				};
				return group;
			},
			createMedicationSubGroup : function (parentlinkId, medNum, med) {
				var linkId = parentlinkId + "." + medNum;
				var subgroup = {
					linkId: linkId,
					question: []
				};
				var medFrequencyItems = ["1 time", "2 times", "3 times", "4 times", "5 times", "6 times", "other"];
				var freqOptions = ["a day", "every other day", "a week", "every other week", "a month", "other"];
				var dosesMissedFrequencyItems = ["None", "1 time", "2 times", "3 times",  "4 times", "5 or more times"];

				subgroup.question.push(this.createAnswer(linkId + ".1", "string",med.name));
				subgroup.question.push(this.createAnswer(linkId + ".2", "string",med.dose));
				subgroup.question.push(this.createAnswer(linkId + ".3", "choice",med.frequency, medFrequencyItems.indexOf(med.frequency)));
				if(med.frequencyOther) subgroup.question.push(this.createAnswer(linkId + ".4", "string",med.frequencyOther));
				subgroup.question.push(this.createAnswer(linkId + ".5", "choice",med.timeUnit, freqOptions.indexOf(med.timeUnit)));
				if(med.timeUnitOther) subgroup.question.push(this.createAnswer(linkId + ".6", "string",med.timeUnitOther));
				subgroup.question.push(this.createAnswer(linkId + ".7", "choice",med.missedDoses, dosesMissedFrequencyItems.indexOf(med.missedDoses)));

				return subgroup;
			},
			createOtherMedicationsGroup: function (linkId) {
				var group = {
					linkId: linkId,
					question: [this.createAnswer(linkId + ".1", "string",this.currEvaluation.otherMedication || 'N/A')]
				};

				return group;
			},
			createImageGroup : function (imageSection, imageType, sectionLinkId, typeLinkId) {
				var group = {
					linkId: this.getLinkId("MEDIA"),
					group: []
				};

				var subgroup = this.createImageSectionGroup(imageSection, imageType, sectionLinkId, typeLinkId);
				if (subgroup) {
					group.group.push(subgroup);
				}

				return group;
			},
			createOptionalImageGroup : function () {
				var image = _.find(this.currEvaluation.images, function (img) {
					return img.imageClass === 'OPTIONAL' && img.imageNumber === 1;
				});
				var linkId = this.getLinkId("MEDIA_OPTIONAL");
				var group = {
					linkId: linkId
				};

				if (this.currEvaluation.isOptionalImages) {
					group.group = [];
				}

				if (image) {
					group.group.push(this.createImageTypeSubGroup(linkId+ ".1", image));
				}

				return group;
			},
			createImageSectionGroup : function (imageSection, imageType, sectionLinkId, typeLinkId) {
				var image = _.find(this.currEvaluation.images, function (img) {
					return img.imageSection.name === imageSection && img.imageType.name === imageType;
				});

				if (!image) {
					return null;
				};

				var group = {
					linkId: sectionLinkId,
					group: [this.createImageTypeSubGroup(typeLinkId, image)]
				};
				return group;
			},
			updateImageTypeGroup : function (imageSection, imageType, imageNum, typeLinkId) {
				if (imageType.indexOf("CLOSEUP") >= 0) {
					imageType = "CLOSE_UP";
				}
				var image = _.find(this.currEvaluation.images, function (img) {
					return img.imageSection.name === imageSection && img.imageType.name === imageType && (img.imageClass === 'PRIMARY'? 1 : img.imageNumber === imageNum);
				});

				if (!image) {
					return null;
				}

				return this.createImageTypeSubGroup(typeLinkId, image);
			},
			refreshImageSectionGroup : function (imageSection, sectionLinkId) {
				var that = this;
				var images = _.filter(this.currEvaluation.images, function (img) {
					return img.imageSection.name === imageSection && img.imageNumber !== 10;
				});

				var group = {
					linkId: sectionLinkId,
					group: []
				};

				images.forEach(function (image) {
					var imageType = image.imageType.name === 'CLOSE_UP' ? imageSection + "_CLOSEUP" + image.imageNumber : image.imageType.name;
					var typeLinkId = that.getLinkId(imageType);
					group.group.push(that.createImageTypeSubGroup(typeLinkId, image));
				});

				return group;
			},
			refreshOptionalImagesGroup : function () {
				var that = this;
				var images = _.filter(this.currEvaluation.images, function (img) {
					return img.imageClass === 'OPTIONAL' && img.imageNumber !== 10;
				});

				var group = [];

				images.forEach(function (image) {
					group.push(that.createImageTypeSubGroup(that.getLinkId("MEDIA_OPTIONAL") + "." + image.imageNumber, image));
				});

				return group;
			},
			createImageTypeSubGroup : function (typeLinkId, image) {
				var group = {
					linkId: typeLinkId,
					question: []
				};
				var qAnswers = [
					{
						linkId: typeLinkId + ".1",
						text: image.imageClass,
						answer: [ {valueString: (image || {}).id || ''}]
					},
					{
						linkId: typeLinkId + ".2",
						answer: [{valueBoolean: (image || {}).isImageInVista || false}]
					},
					{
						linkId: typeLinkId + ".3",
						answer: [{valueBoolean: (image || {}).deleteImage || false}]
					}
				];

				if (image && image.imageClass !== 'PRIMARY') {
					qAnswers.push(
						{
							linkId: typeLinkId + ".4",
							answer: [{valueInteger: (image || {}).imageNumber || ''}]
						});

					qAnswers.push(
						{
							linkId: typeLinkId + ".5",
							answer: [{valueString: (image || {}).imageDescription || ''}]
						});
				}
				group.question = qAnswers;
				return group;
			},
			createAdditionalCommentsGroup: function (linkId) {
				var group = {
					linkId: linkId,
					question: [this.createAnswer(linkId + ".1", "string",this.currEvaluation.additionalComments || 'N/A')]
				};

				return group;
			},
			createResponseSummaryGroup: function (linkId) {
				var group = {
					linkId: linkId,
					question: [this.createAnswer(linkId + ".1", "bool",this.currEvaluation.isResponsesAccepted)]
				};

				return group;
			},
			getMedicationTypes :  function (jsonObject) {
				var that = this;
				var selectedMedTypes = [];
				var medTypes = medicationTypes.concat(["OTHER"]);
				if (jsonObject.group && jsonObject.group.group) {
					medTypes.forEach(function (medType) {
						var grpName = medType + "_MEDICATIONS";
						if (_.findIndex(jsonObject.group.group, {linkId: that.getLinkId(grpName)}) >= 0)
							selectedMedTypes.push(medType);
					});
				}
				return selectedMedTypes;
			},
			getMedications :  function (jsonObject) {
				var that = this;
				var medications = [];
				if (jsonObject.group && jsonObject.group.group) {
					medicationTypes.forEach(function (medType) {
						var grpName = medType + "_MEDICATIONS";
						var medTypelinkId = that.getLinkId(grpName);
						if (_.findIndex(jsonObject.group.group, {linkId: medTypelinkId}) >= 0)
							medications.push.apply(medications, that.getMedication(jsonObject, medTypelinkId, medType));
					});
				}
				return medications;
			},
			getMedication :  function (jsonObject, linkId, medType) {
				var medGroup = this.findElement(jsonObject, linkId);
				var meds = [];
				if (medGroup.group && medGroup.group.length) {
					for (var i = 0; i < medGroup.group.length; i++) {
						var med = {
							"type": medType,
							"name": this.getValue(medGroup.group[i], medGroup.group[i].linkId + ".1"),
							"dose": this.getValue(medGroup.group[i], medGroup.group[i].linkId + ".2"),
							"frequency": this.getValue(medGroup.group[i], medGroup.group[i].linkId + ".3"),
							"frequencyOther": this.getValue(medGroup.group[i], medGroup.group[i].linkId + ".4") || '',
							"timeUnit": this.getValue(medGroup.group[i], medGroup.group[i].linkId + ".5"),
							"timeUnitOther": this.getValue(medGroup.group[i], medGroup.group[i].linkId + ".6") || '',
							"missedDoses": this.getValue(medGroup.group[i], medGroup.group[i].linkId + ".7"),
						};
						meds.push(med);
					}
				}
				return meds;
			},
			getImages :  function (jsonObject) {
				var images = [];
				if (jsonObject.group && jsonObject.group.group) {
					var mediaGrp = this.findElement(jsonObject, this.getLinkId("MEDIA"));

					if (mediaGrp && mediaGrp.group && mediaGrp.group.length) {
						var imageSectionList = mediaGrp.group;
						for (var i=0; i < imageSectionList.length; i++) {
							var imageSection = this.getLinkText(imageSectionList[i].linkId);
							if (imageSectionList[i].group && imageSectionList[i].group.length) {
								var imageTypeList = imageSectionList[i].group;
								for (var j = 0; j < imageTypeList.length; j++) {
									var imageType = this.getLinkText(imageTypeList[j].linkId);
									imageType = imageType.indexOf('CLOSEUP') >= 0 ? 'CLOSE_UP' : imageType;
									images.push(this.getImage(imageTypeList[j], imageSection, imageType));
								}
							}
						}
					}

					var optionalGrp = this.findElement(jsonObject, this.getLinkId("MEDIA_OPTIONAL"));
					if (optionalGrp && optionalGrp.group && optionalGrp.group.length) {
						for (var i=0; i < optionalGrp.group.length; i++) {
							images.push(this.getImage(optionalGrp.group[i], "OTHER", "OTHER"));
						}
					}
				}
				return images;
			},
			getImage :  function (jsonObject, imageSection, imageType) {
				var urlObj = this.findElement(jsonObject, jsonObject.linkId + ".1");
				var id = this.getValue(jsonObject, urlObj.linkId) || '';

				var imageTypeDesc = _.find(imageTypesBySection[imageSection],{name: imageType});

				var image = {
					id: id,
					imageUrl: this.resourceLinks['media'].replace("{MEDIA_ID}",id),
					imageSection: {
						name: imageSection,
						description: imageSectionsMap[imageSection] ? imageSectionsMap[imageSection].description : 'Other'
					},
					imageType: {
						name: imageType,
						description: imageTypeDesc ? imageTypeDesc.description : 'Other'
					},
					imageClass: urlObj.text,
					imageDescription: this.getValue(jsonObject, jsonObject.linkId + ".5") || '',
					imageNumber: this.getValue(jsonObject, jsonObject.linkId + ".4") || 0
				};

				return image;
			},
			setMedia: function (image) {
				var index = _.findIndex(this.currEvaluation.images, function (img) {
					return img.id === image.id || (img.imageSection.name === image.imageSection.name && img.imageType.name === image.imageType.name && img.imageNumber === image.imageNumber);
				});

				if (index === -1) {
					this.currEvaluation.images.push(image);
				}
				else {
					this.currEvaluation.images[index] = image;
				}

				this.initUploadedImagesBySection();
			},
			initUploadedImagesBySection: function () {
				var evaluation = this.currEvaluation || {};
				var images = evaluation.images || [];
				images = _.filter(images, function (image) { return (typeof image.deleteImage === 'undefined'|| !image.deleteImage)});

				uploadedImagesBySection = {
					'OPTIONAL': []
				};

				Object.keys(imageTypesBySection).forEach(function (sectionName) {
					uploadedImagesBySection[sectionName] = {
						'PRIMARY': [],
						'CLOSE_UP': []
					};
				});

				var sectionNames = [];

				images.forEach(function (image) {
					if (image.imageClass === 'OPTIONAL') {
						uploadedImagesBySection['OPTIONAL'].push(image);
					} else {
						var sectionName = image.imageSection.name;
						sectionNames.push(sectionName);
						uploadedImagesBySection[sectionName][image.imageClass].push(image);
					}
				});

				sectionNames.forEach(function (section) {
					uploadedImagesBySection[section]['CLOSE_UP'].sort(function (img1, img2) {
						return img1.imageNumber - img2.imageNumber;
					});
				});

				uploadedImagesBySection['OPTIONAL'].sort(function (img1, img2) {
					return img1.imageNumber - img2.imageNumber;
				});
			},
			getMedsByType: function (medType) {
				var meds = [];

				this.currEvaluation.medications.forEach(function (med) {
					if (med.type === medType) {
						meds.push(med);
					}
				});

				return meds;
			},
			updateMedsByType: function (meds, medType) {
				var noMedsOfType = _.filter(this.currEvaluation.medications, function (med) {
					return med.type !== medType;
				});

				this.currEvaluation.medications = noMedsOfType.concat(meds);
			},
			getPrimaryImage: function (imageTypeName, imageSectionName) {
				return _.find(uploadedImagesBySection[imageSectionName]['PRIMARY'], function (image) {
					return image.imageType.name === imageTypeName;
				});
			},
			getCloseUpImage: function (imageSectionName, index) {
				return uploadedImagesBySection[imageSectionName]['CLOSE_UP'][index];
			},
			getOptionalImage: function (index) {
				return uploadedImagesBySection['OPTIONAL'][index];
			},
			createImagePlaceholder: function (image) {
				var evaluation = this.currEvaluation;
				evaluation.images.push(image);

				this.initUploadedImagesBySection();
			},
			deletePhotos: function (photoIds) {
				var that = this;
				var pageNumber = this.currEvaluation.pageNumber;
				hasDeletedCloseups = false;
				hasDeletedOptionals = false;
				var refDeferreds = [];
				var deferred = $q.defer();

				this.currEvaluation.images.forEach(function (image) {
					if (photoIds.indexOf(image.id) >= 0) {
						refDeferreds.push(that.deleteMedia(image.id));

						image.deleteImage = true;
						pageNumber--;

						var imageSection = image.imageSection.name;
						var imageClass = image.imageClass;
						if (imageClass === 'CLOSE_UP') {
							_.where(that.currEvaluation.images, { imageClass: 'CLOSE_UP', imageSection : {name : imageSection}}).forEach(function (closeup) {
								hasDeletedCloseups = true;
								if (image.imageNumber < closeup.imageNumber && closeup.imageNumber <= 3)
									closeup.imageNumber--;
							});
						}
						else if (imageClass === 'OPTIONAL') {
							_.where(that.currEvaluation.images, { imageClass: 'OPTIONAL'}).forEach(function (optionalImage) {
								hasDeletedOptionals = true;
								if (image.imageNumber < optionalImage.imageNumber && optionalImage.imageNumber <=3)
									optionalImage.imageNumber--;
							});
						}

						image.imageNumber = 10;

					}
				});

				if (hasDeletedOptionals) {
					var optionals = _.filter(that.currEvaluation.images, function (image) {
						return  (image.imageClass === 'OPTIONAL' && image.imageNumber <=3);
					});
					
					if (optionals && optionals.length  === 0) {
						pageNumber--;
						that.currEvaluation.isOptionalImages = false;
					}
				}
				this.currEvaluation.pageNumber = pageNumber;
				this.initUploadedImagesBySection();

				$q.all(refDeferreds).then(function () {
					deferred.resolve();
				});

				return deferred.promise;
			}
		}

		angular.extend(service, questionnaireResponseService);

		return service;
	});
});