define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('imageMediaRequestService', function ($http, $q, localResourceDirectoryService, imageResponseService) {

		var currMediaRequest = {};
		var currEvaluation = {};

		var imageSectionsMap = {};

		var imageTypesBySection = {};

		return {
			getMediaRequest: function () {
				return currMediaRequest;
			},
			getImageTypesBySection: function () {
				return imageTypesBySection;
			},
			getImageSectionsMap: function () {
				return imageSectionsMap;
			},
			setQuestionnaireResponseId: function (responseId) {
				currMediaRequest.questionnaireResponse = responseId;
			},
			setMediaRequest: function (mediaRequest) {
				var deferred = $q.defer();
				var that = this;

				currMediaRequest = mediaRequest;

				this.fetchImageSections().then(function () {
					that.initImageTypesBySection();
					imageResponseService.setImageTypesBySection(imageTypesBySection);
					imageResponseService.setImageSectionsMap(imageSectionsMap);
					imageResponseService.initEvaluation('MyTelederm', mediaRequest.id, mediaRequest.questionnaireResponse).then(
						function () {
							imageResponseService.initUploadedImagesBySection();
							deferred.resolve();
						}
					);
				});

				return deferred.promise;
			},
			fetchImageSections: function () {
				var deferred = $q.defer();
				var that = this;

				if (Object.keys(imageSectionsMap).length) {
					deferred.resolve();
				} else {
					localResourceDirectoryService.fetch().then(function (resourceLinks) {
						$http({
							method: 'GET',
							url: resourceLinks['image-sections']
						}).success(function (sections) {
							that.initImageSectionsMap(sections);
							deferred.resolve();
						}).error(function (error) {
							deferred.reject(error);
						});
					});
				}

				return deferred.promise;
			},
			initImageSectionsMap: function (sections) {
				sections = sections || [];

				imageSectionsMap = {};

				sections.forEach(function (section) {
					var key = section.name.split('_')[0];

					imageSectionsMap[key] = section;
				});
			},
			initImageTypesBySection: function () {
				var imageTypes = currMediaRequest.mediaTypes || [];
				imageTypesBySection = {};

				imageTypes.forEach(function (imageType) {
					var imageTypeName = imageType.name || '';
					var section = imageSectionsMap[imageTypeName.split('_')[0]] || {};
					var sectionName = section.name;

					if (sectionName) {
						imageTypesBySection[sectionName] = imageTypesBySection[sectionName] || [];

						imageTypesBySection[sectionName].push(imageType);
					}
				});
			},
			saveMediaRequest: function () {
				var deferred = $q.defer();

				localResourceDirectoryService.fetch().then(function (resourceLinks) {
					var url = resourceLinks['update-request'];
                    
					url = url.replace('{MEDIA_REQUEST_ID}', currMediaRequest.id);

					var updateObj = {
						status: currMediaRequest.status,
					 	questionnaireResponse :  currMediaRequest.questionnaireResponse
					};

					$http({
						method: 'PATCH',
						url: url,
						data: JSON.stringify(updateObj)
					}).success(function () {
						deferred.resolve();
					}).error(function (error) {
						deferred.reject(error);
					});
				});

				return deferred.promise;
			}
		}
	});
});