define(['TeledermEvalController'], function () {
    'use strict';

    describe('Telederm Eval Controller', function () {
        var controller,
            scope,
            focusServiceMock,
            progressServiceMock;

        beforeEach(function () {
            module('angularTemplateApp');

            focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
            progressServiceMock = jasmine.createSpyObj('progressService', ['getProgress']);

            progressServiceMock.getProgress.and.returnValue(45);

            module(function ($provide) {
                $provide.value('focusService', focusServiceMock);
                $provide.value('globalDelayTracker', {});
                $provide.value('progressService', progressServiceMock);
            });

            inject(function ($rootScope, $controller) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

        it('should set the subtitle', function () {
            controller = controller('TeledermEvalController', {$scope: scope});

            expect(scope.subtitle).toEqual('Follow-Up Request Questionnaire');
        });

        it('should set the ariaLabel', function () {
            controller = controller('TeledermEvalController', {$scope: scope});

            expect(scope.ariaLabel).toEqual('Follow-Up Request Questionnaire, Progress: 45%');
        });

        it('should extend the SubheaderController', function () {
            controller = controller('TeledermEvalController', {$scope: scope});

            spyOn(window, '$').and.callFake(function (selector) {
                return selector
            });

            expect(focusServiceMock.focusElement).toHaveBeenCalledWith('.primary-header h2');
        });
    });
});