define(['TakeAnotherPictureController'], function() {
    'use strict';

    describe("The Take Another Picture Controller", function () {
        var controller,
            scope,
            imageResponseServiceMock,
            mediaRequestNavigationServiceMock,
            evaluation = {};

        beforeEach(function () {
            module('angularTemplateApp');

            imageResponseServiceMock = jasmine.createSpyObj('imageResponseService', ['getEvaluation']);
            mediaRequestNavigationServiceMock = jasmine.createSpyObj('mediaRequestNavigationService', ['previousPage', 'nextPage']);

            imageResponseServiceMock.getEvaluation.and.callFake(function () {
                return evaluation;
            });

            module(function ($provide) {
                $provide.value('imageResponseService', imageResponseServiceMock);
                $provide.value('mediaRequestNavigationService', mediaRequestNavigationServiceMock);
            });

            inject(function($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

		describe("initial state", function () {
            it("should correctly set initial values", function() {
                evaluation = {};

                controller = controller('TakeAnotherPictureController', {$scope: scope});
                scope.$apply();
                expect(scope.evaluation).toEqual({});
            });
        });

        describe("previous function", function () {
            it("should call the previousPage function on the mediaRequestNavigationService", function () {
                controller = controller('TakeAnotherPictureController', {$scope: scope});
                scope.previous();

                expect(mediaRequestNavigationServiceMock.previousPage).toHaveBeenCalled();
            });
        });

        describe("takeAnotherPicture function", function () {
            beforeEach(function () {
                evaluation = {};

                controller = controller('TakeAnotherPictureController', {$scope: scope});
                scope.$apply();

                scope.takeAnotherPicture();
            });

            it("should set isOptionalImages on the evaluation to true", function () {
                expect(evaluation.isOptionalImages).toBeTruthy();
            });

            it("should call the nextPage function on the mediaRequestNavigationService", function () {
                expect(mediaRequestNavigationServiceMock.nextPage).toHaveBeenCalled();
            });
        });

        describe("skip function", function () {
            beforeEach(function () {
                evaluation = {};

                controller = controller('TakeAnotherPictureController', {$scope: scope});
                scope.$apply();

                scope.skip();
            });

            it("should set isOptionalImages on the evaluation to false", function () {
                expect(evaluation.isOptionalImages).toBeFalsy();
            });

            it("should call the nextPage function on the mediaRequestNavigationService", function () {
                expect(mediaRequestNavigationServiceMock.nextPage).toHaveBeenCalled();
            });
        });
    });
});