define(['angular', 'app'], function (angular, app) {
    'use strict';
    app.controller('TeledermSubmitController', function ($scope, $controller, mediaRequestNavigationService, imageMediaRequestService,imageResponseService, teledermSubmitEvaluationService) {
        $scope.infoText = 'After reviewing the information you submitted, the dermatologist may need to contact you with follow up questions';

        $scope.submitCallback = function () {
            var mediaRequest = imageMediaRequestService.getMediaRequest();
            var evaluation = imageResponseService.getEvaluation();

            mediaRequest.status = "SUBMITTED";
			evaluation.status = "COMPLETED";

            teledermSubmitEvaluationService.reset();
            teledermSubmitEvaluationService.submit();
        };

        $scope.previousCallback = function () {
            mediaRequestNavigationService.previousPage();
        };

        $scope.showProgressBar = true;
        
        angular.extend(this, $controller('SubmitController', {$scope: $scope}));
    });
});