define(['TeledermSubmitController'], function() {
    'use strict';

    describe("The Telederm Submit Controller", function () {
        var controller,
            scope,
            mediaRequestNavigationServiceMock,
            imageMediaRequestServiceMock,
            teledermSubmitEvaluationServiceMock,
            fhirPatientMock,
            mediaRequest = {
                status: ''
            },
            evaluation = {
                status: ''
            },
            imageResponseServiceMock;

        beforeEach(function () {
            module('angularTemplateApp');

            mediaRequestNavigationServiceMock = jasmine.createSpyObj('mediaRequestNavigationService', ['previousPage', 'nextPage']);
            imageMediaRequestServiceMock = jasmine.createSpyObj('imageMediaRequestService', ['getMediaRequest']);
            teledermSubmitEvaluationServiceMock = jasmine.createSpyObj('teledermSubmitEvaluationService', ['reset', 'submit']);
            fhirPatientMock = jasmine.createSpyObj('fhirPatient', ['fetch']);
            imageResponseServiceMock = jasmine.createSpyObj('imageResponseService', ['getEvaluation']);

            imageMediaRequestServiceMock.getMediaRequest.and.callFake(function () {
                return mediaRequest;
            });

            imageResponseServiceMock.getEvaluation.and.callFake(function () {
                return evaluation;
            });

            fhirPatientMock.fetch.and.returnValue({
                then: function () {}
            });

            module(function ($provide) {
                $provide.value('mediaRequestNavigationService', mediaRequestNavigationServiceMock);
                $provide.value('imageMediaRequestService', imageMediaRequestServiceMock);
                $provide.value('teledermSubmitEvaluationService', teledermSubmitEvaluationServiceMock);
                $provide.value('fhirPatient', fhirPatientMock);
                $provide.value('imageResponseService', imageResponseServiceMock);
            });

            inject(function($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

        describe("initial state", function () {
            it("should correctly set initial values", function () {
                controller = controller('TeledermSubmitController', {$scope: scope});
                scope.$apply();

                expect(scope.showProgressBar).toBeTruthy();
                expect(scope.infoText).toEqual('After reviewing the information you submitted, the dermatologist may need to contact you with follow up questions');
            });
        });

        describe("submitCallback", function () {
            var result;

            beforeEach(function () {
                controller = controller('TeledermSubmitController', {$scope: scope});
                evaluation = {
                    status: 'STARTED'
                };

                mediaRequest = {
                    status: 'PENDING'
                };

                scope.submitCallback();
            });
            
            it("should update the evaluation status", function () {
                expect(evaluation).toEqual({
                    status: 'COMPLETED'
                });
            });

            it("should update the mediaRequest status", function () {
                expect(mediaRequest).toEqual({
                    status: 'SUBMITTED'
                });
            });

            it("should reset the submitEvaluation service", function () {
                expect(teledermSubmitEvaluationServiceMock.reset).toHaveBeenCalled();
            });

            it("should submit the evaluation", function () {
                expect(teledermSubmitEvaluationServiceMock.submit).toHaveBeenCalled();
            });
        });

        describe("previousCallback function", function () {
            it("should call the previousPage function on the mediaRequestNavigationService", function () {
                controller = controller('TeledermSubmitController', {$scope: scope});
                scope.previousCallback();

                expect(mediaRequestNavigationServiceMock.previousPage).toHaveBeenCalled();
            });
        });

        it("should extend the shared SubmitController", function () {
            controller = controller('TeledermSubmitController', {$scope: scope});

            expect(scope.contactType).toEqual('email');
            expect(scope.contactInfo).toEqual({
                email: '',
                phone: ''
            });
        });
    });
});