define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.controller('SkinStatusController', function ($scope, $rootScope, NavigationInstructionsService, mediaRequestNavigationService, imageMediaRequestService, imageResponseService, localStorageService, userSessionService, focusService, $timeout) {
		$scope.mediaRequest = imageMediaRequestService.getMediaRequest();
		$scope.evaluation = imageResponseService.getEvaluation();
		$scope.skinStatusTypes = {	"Better": "BETTER",
									"Unchanged": "UNCHANGED",
									"Worse": "WORSE" };

		$scope.openNavigationTipsModal = function() {
			NavigationInstructionsService.openModal();
		}

		if (!localStorage.getItem(localStorageService.keys['no-show-navigation-tips'])) {
			userSessionService.fetch().then(function(user) {
				if(localStorageService.showModal(user,'no-show-navigation-tips',null) === true) {
					$scope.openNavigationTipsModal();
				}
			});
		}

		$scope.setSkinStatus = function(type) {
			$scope.evaluation.skinStatus = type;
			$scope.evaluation.skinStatusComment = '';
			$timeout(function () {
				focusService.focusElement('#skinCheck-comments');
			});
		}

		$scope.next = function () {
			var isValid = true;
			if (!$scope.evaluation.skinStatus) {
				isValid = false;
			}
			$scope.skinStatusForm.$setValidity("Skin-Status-Required", isValid);
			this.skinStatusForm.validationSummary.validate().then(function(){
				mediaRequestNavigationService.nextPage();
			});
		};

		$scope.errorHandling = {
			'Skin-Status-Required' : {
				message : 'Please select appropriate skin condition choice before proceeding further.',
				priority : 1
			}
		};

		$scope.swipeRight = function(){
			$rootScope.$broadcast('swipeRight');
		};
	});
});
