define(['SkinStatusController', 'localStorageService'], function() {
    'use strict';

    describe("The SkinStatus Controller", function () {
        var controller,
            scope,
            stateMock,
            NavigationInstructionsServiceMock,
            mediaRequestNavigationServiceMock,
            imageMediaRequestServiceMock,
            rootScope,
            form,
			service,
			userSessionServiceMock,
            mhpUserMock,
            focusServiceMock,
            itemFound = false,
            timeout,
            imageResponseServiceMock,
            evaluation = {};

        beforeEach(function () {
            module('angularTemplateApp');

            stateMock = jasmine.createSpyObj('state', ['go']);
            NavigationInstructionsServiceMock = jasmine.createSpyObj('NavigationInstructionsService', ['openModal']);
            mediaRequestNavigationServiceMock = jasmine.createSpyObj('mediaRequestNavigationService', ['nextPage']);
            imageMediaRequestServiceMock = jasmine.createSpyObj('imageMediaRequestService', ['getMediaRequest']);
            userSessionServiceMock = jasmine.createSpyObj('userSessionService', ['fetch']);
            focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
            imageResponseServiceMock = jasmine.createSpyObj('imageResponseService', ['getEvaluation']);

            spyOn(localStorage, 'getItem').and.callFake(function () {
                return itemFound;
            });

			userSessionServiceMock.fetch.and.returnValue({
				then: function (callback) {
					callback({id:1});
				}
            });
            
            imageResponseServiceMock.getEvaluation.and.callFake(function () {
                return evaluation;
            });

            module(function ($provide) {
                $provide.value('$state', stateMock);
                $provide.value('NavigationInstructionsService', NavigationInstructionsServiceMock);
                $provide.value('mediaRequestNavigationService', mediaRequestNavigationServiceMock);
                $provide.value('imageMediaRequestService', imageMediaRequestServiceMock);
				$provide.value('mhpuser', mhpUserMock);
                $provide.value('userSessionService', userSessionServiceMock);
                $provide.value('focusService', focusServiceMock);
                $provide.value('imageResponseService', imageResponseServiceMock);
			});

            inject(function($controller, $rootScope, $state, $compile, localStorageService, $timeout) {
                scope = $rootScope.$new();
                rootScope = $rootScope;
                service =  localStorageService;
                timeout = $timeout;
                spyOn(service, 'encrypt').and.returnValue("");
                spyOn(service, 'showModal').and.returnValue(true);
				controller = $controller;
                spyOn(rootScope, '$broadcast');

                scope.skinStatusForm = {
					validationSummary: {
						validate: function () {}
                    },
                    $setValidity: function() {}
                };
                
                spyOn(scope.skinStatusForm.validationSummary, 'validate').and.returnValue({
					then: function (callback) {
						callback();
					}
				});
            });
        });
        
        describe("swipeRight function", function () {
			it("should broadcast swipeRight", function () {
                controller = controller('SkinStatusController', {$scope: scope});
                scope.swipeRight();
				expect(rootScope.$broadcast).toHaveBeenCalledWith('swipeRight');
			});
        });
        
        describe("setSkinStatus function", function () {
            beforeEach(function () {
                controller = controller('SkinStatusController', {$scope: scope});
                scope.evaluation = {
                    'skinStatus': '',
                    'skinStatusComment': ''
                };
                scope.setSkinStatus('BETTER');
                timeout.flush();
            });

			it("should set evaluation.skinStatus value", function () {
                expect(scope.evaluation.skinStatus).toBe('BETTER');
            });
            
            it("should set focus to the skin status comments field if an item is selected", function () {
                expect(focusServiceMock.focusElement).toHaveBeenCalledWith('#skinCheck-comments');
            });

            it("should clear out evaluation.skinStatusComment when setSkinStatus is called", function () {
                expect(scope.evaluation.skinStatusComment).toBe('');
            });
        });
        
        describe("next function", function () {
			it("should validate the skinStatus and continue to next page", function () {
                controller = controller('SkinStatusController', {$scope: scope});
                scope.evaluation = {'skinStatus': 'BETTER'};
                scope.next();
				expect(mediaRequestNavigationServiceMock.nextPage).toHaveBeenCalled();
            });
            
            it("should validate the skinStatus and not continue", function () {
                controller = controller('SkinStatusController', {$scope: scope});
                scope.evaluation = {'skinStatus': ''};
                scope.skinStatusForm.validationSummary = {
					validate: function() {
                        return {then: function () {
                            //empty success block
                        }}
                    }
                };
                scope.next();
				expect(mediaRequestNavigationServiceMock.nextPage).not.toHaveBeenCalled();
			});
		});

		describe("navigation tips modal", function (){

			it ('should open the tips modal', function () {
				controller = controller('SkinStatusController', {$scope: scope});
				scope.openNavigationTipsModal();
				expect(NavigationInstructionsServiceMock.openModal).toHaveBeenCalled();
			});

			it ('should open the tips modal if session variable is not set', function () {
				controller = controller('SkinStatusController', {$scope: scope});
				expect(NavigationInstructionsServiceMock.openModal).toHaveBeenCalled();
			});

			it ('should not open the tips modal if session variable is set', function () {
                itemFound = true;
				controller = controller('SkinStatusController', {$scope: scope});
				expect(NavigationInstructionsServiceMock.openModal).not.toHaveBeenCalled();
			});
		})
    });
});