define(['angular', 'app'], function (angular, app) {
    'use strict';
    app.controller('ReviewPhotosController', function ($scope, $rootScope, $state, $stateParams, $http, $modal, modalService, focusService, mediaRequestNavigationService, imageMediaRequestService, imageResponseService, imageRotationService, formatter) {
		$scope.deletedPhotos = [];
		$scope.imageSectionsMap = imageMediaRequestService.getImageSectionsMap();
		$scope.images = imageResponseService.getUploadedImagesBySection();
		$scope.optionalPhotos = $scope.images['OPTIONAL'];
		$scope.submitted = $stateParams.submitted || false;
		$scope.imageSections = _.filter(Object.keys($scope.images),  function (section) {
			return section !== 'OPTIONAL';
		});


		var android = navigator.userAgent.toLowerCase().indexOf('android') > -1;
		$scope.isIE11 = !!window.MSInputMethodContext && !!document.documentMode;

		$scope.rotateImage =  function (image) {
			if (image.imageUrl) {
				$http({
					url: image.imageUrl,
					method: 'GET',
				}).then(function (response) {
					image.src = "data:" + response.data.content.contentType + ";base64," + response.data.content.data;
					image.fileName = response.data.content.title;
					if (android) {
						imageRotationService.getRotateClass(formatter.base64toBlob(image.src)).then(function (rotateClass) {
							image.rotateClass = rotateClass;
						});
					}
				});
			}
		}

		$scope.setDeleted = function(photoId){
			var index = $scope.deletedPhotos.indexOf(photoId);
			if (index == -1) {
				$scope.deletedPhotos.push(photoId);
			} else {
				$scope.deletedPhotos.splice(index, 1);
			}
		};

		$scope.isSelected = function (photoId) {
			return ($scope.deletedPhotos.indexOf(photoId) === -1);
		};

		$scope.imageSections.forEach(function (imageSection) {
			$scope.images[imageSection]['PRIMARY'].forEach(function(photo) {
				$scope.rotateImage(photo);
			});
			$scope.images[imageSection]['CLOSE_UP'].forEach(function(photo) {
				$scope.rotateImage(photo);
			});
		});

        $scope.optionalPhotos.forEach(function (photo) {
            $scope.rotateImage(photo);
        });

		$scope.getImagesByClassAndSection = function (imageClass, imageSection) {
			return $scope.images[imageSection][imageClass];
		};

		$scope.getSectionDescription = function (section) {
			return $scope.imageSectionsMap[section.split('_')[0]].description
		};

		$scope.errorHandling = {};

        $scope.validateCloseups = function () {
			$scope.reviewPhotosForm.$error = {};

			var errorNumber = 0;
			$scope.imageSections.forEach(function (section) {
				var isValid = true;
				var closeups = $scope.images[section]['CLOSE_UP'];
				var imageIds = closeups.map(function (a) {
					return a.id;
				});
				var selectedIds = _.difference(imageIds, $scope.deletedPhotos);

				if (!selectedIds || selectedIds.length === 0) {
					isValid = false;
					errorNumber++;
				}

				if (!isValid) {
					$scope.errorHandling["CloseUp_Required_" + errorNumber] =
					{
						message: "You must select at least one close up photo for " + $scope.getSectionDescription(section) + ".",
						priority: 1
					}
				}
			});

			if (errorNumber === 0)
				$scope.reviewPhotosForm.$setValidity(errorNumber, true);
			else {
				for (var i = 1; i <= errorNumber; i++)
					$scope.reviewPhotosForm.$setValidity("CloseUp_Required_" + i, false);
			}
		};

		$scope.showDeleteConfirmation = function(){
			var messages = [];
			var message = "";
            var imagesList = imageResponseService.getEvaluation().images;
			$scope.deletedPhotos.forEach(function(id){
				var deletedImage = _.find(imagesList, {id: id});
				if(deletedImage){
					message = (deletedImage.imageClass === 'CLOSE_UP' ?  $scope.getSectionDescription(deletedImage.imageSection.name) + " Close up " : "Optional Photo ") + deletedImage.imageNumber;
					messages.push(message);
				};
			})

			var modalOptions = {
				closeButtonText: 'No',
				actionButtonText: 'Yes',
				headerText: 'Confirmation',
				bodyContentUrl: 'modules/ui-components/modals/confirm-delete/confirm-delete_template.html',
				data: {
					messages: messages
				}};

			return modalService.showModal({}, modalOptions);
		};

		$scope.next = function () {
			$scope.validateCloseups();
			this.reviewPhotosForm.validationSummary.validate().then(function(){
				if($scope.deletedPhotos.length > 0) {
					$scope.showDeleteConfirmation().then(function () {
						imageResponseService.deletePhotos($scope.deletedPhotos).then(function () {
							mediaRequestNavigationService.nextPage();
						});
					}, function () {
						focusService.focusElement($('button[ng-click="goNext()"]'));
					});
				}
				else {
					mediaRequestNavigationService.nextPage();
				}
			});
        };

		$scope.previous = function () {
			$scope.validateCloseups();
			this.reviewPhotosForm.validationSummary.validate().then(function(){
				if($scope.deletedPhotos.length > 0) {
					$scope.showDeleteConfirmation().then(function () {
						imageResponseService.deletePhotos($scope.deletedPhotos).then(function () {
							mediaRequestNavigationService.previousPage();
						});
					}, function () {
						focusService.focusElement($('button[ng-click="goPrevious()"]'));
					});
				}
				else {
					mediaRequestNavigationService.previousPage();
				}
			});
		};

		$scope.swipeLeft = function(){
			if (!$scope.submitted) {
				$rootScope.$broadcast('swipeLeft');
			}
		};

		$scope.swipeRight = function(){
			if (!$scope.submitted) {
				$rootScope.$broadcast('swipeRight');
			}
		};

		$scope.back = function () {
			$state.go('main.mytelederm.media-request-info');
		};

		var modalInfo = {value: null, dismissed: true, resendHash: []};
		var modalInstance;
		var controller;
		var openModal = function (template, controller, modalInfo) {
			modalInstance = $modal.open({
				windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
				templateUrl: template,
				controller: controller,
				backdrop: 'static',
				keyboard: false,
				resolve: {
					modalInfo: function () {
						return modalInfo;
					}
				}
			});
		};

		$scope.openReviewAndSubmitTipsModal = function() {
			openModal('modules/ui-components/modals/review-photos-tips/review-photos-tips_template.html', 'ReviewPhotoTipsController', modalInfo);
		};
    });
});