define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.controller('ResponseSummaryController', function ($scope, $rootScope, formatter, medicationTypes, imageResponseService, mediaRequestNavigationService) {
        $scope.evaluation = imageResponseService.getEvaluation();
        $scope.getMedsByType = function (medType) {
			var meds = [];

			$scope.evaluation.medications.forEach(function (med) {
				if (med.type === medType) {
					meds.push(med);
				}
			});

			return meds;
		};
		
        $scope.toTitleCase = formatter.toTitleCase;

        $scope.hasComments = $scope.evaluation.additionalComments !== 'N/A' ? 'Yes' : 'No';
        $scope.comments = $scope.hasComments === 'Yes' ? ' - ' + $scope.evaluation.additionalComments : '';

        $scope.hasMeds = !!$scope.evaluation.medicationTypes.length;

        $scope.medTypes = _.filter($scope.evaluation.medicationTypes, function (medType) {
            return medType !== 'OTHER';
        });

        $scope.hasOtherMeds = $scope.evaluation.medicationTypes.indexOf('OTHER') !== -1;

        $scope.previous = function () {
            mediaRequestNavigationService.previousPage();
        };

        $scope.accept = function () {
            $scope.evaluation.isResponsesAccepted = true;
            mediaRequestNavigationService.nextPage();
        };

		$scope.swipeLeft = function(){
			$rootScope.$broadcast('swipeLeft');
		};
    });
});