define(['PhotoInstructionsController'], function() {
    'use strict';

    describe("The Photo Instructions Controller", function () {
        var controller,
            scope,
            rootScope,
            mediaRequestNavigationServiceMock;

        beforeEach(function () {
            module('angularTemplateApp');

            mediaRequestNavigationServiceMock = jasmine.createSpyObj('mediaRequestNavigationService', ['previousPage', 'nextPage']);

            module(function ($provide) {
                $provide.value('mediaRequestNavigationService', mediaRequestNavigationServiceMock);
            });

            inject(function($controller, $rootScope) {
                scope = $rootScope.$new();
                rootScope = $rootScope;
                controller = $controller;

                spyOn(rootScope, '$broadcast');
            });
        });

        describe("previous function", function () {
            it("should call the previousPage function on the mediaRequestNavigationService", function () {
                controller = controller('PhotoInstructionsController', {$scope: scope});
                scope.previous();

                expect(mediaRequestNavigationServiceMock.previousPage).toHaveBeenCalled();
            });
        });

        describe("next function", function () {
            it("should call the nextPage function on the mediaRequestNavigationService", function () {
                controller = controller('PhotoInstructionsController', {$scope: scope});
                scope.next();

                expect(mediaRequestNavigationServiceMock.nextPage).toHaveBeenCalled();
            });
        });

        describe("swipeLeft function", function () {
			it("should broadcast swipeLeft", function () {
                controller = controller('PhotoInstructionsController', {$scope: scope});
                scope.swipeLeft();
				expect(rootScope.$broadcast).toHaveBeenCalledWith('swipeLeft');
			});
        });
        
        describe("swipeRight function", function () {
			it("should broadcast swipeRight", function () {
                controller = controller('PhotoInstructionsController', {$scope: scope});
                scope.swipeRight();
				expect(rootScope.$broadcast).toHaveBeenCalledWith('swipeRight');
			});
        });
    });
});