define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.controller('RequiredPhotoController', function ($scope, $controller, $stateParams, $modal, imageResponseService, imageUploadService, mediaRequestNavigationService, configServiceValues) {
        $scope.imageSection = $stateParams.imageSection;
        $scope.imageType = $stateParams.imageType;
        $scope.imageNum = $stateParams.imageNum;
        $scope.totalImagesInSection = $stateParams.totalImagesInSection;
        $scope.image = imageResponseService.getPrimaryImage($scope.imageType.name, $scope.imageSection.name);
        $scope.imageSelected = !!$scope.image;
        $scope.hideNext = !($scope.image && !($scope.currPhoto && $scope.currPhoto.fileObj));
        $scope.imageTypeTemplate = "modules/applets/mytelederm/pages/photo-input/partials/_required-photo.html";
        $scope.imageFileSizeLimit = configServiceValues.imageFileSizeLimit;

        $scope.acceptPhotoCallback = function () {
            var data = $scope.image || {
                imageSection: $scope.imageSection,
                imageType: $scope.imageType,
                imageClass: 'PRIMARY'
            };

            data.fileName = $scope.currPhoto.fileObj.name;

            imageUploadService.uploadImage($scope.currPhoto.fileObj, data, false).then(function () {
                mediaRequestNavigationService.nextPage();
            });
        };

        $scope.tip = function() {
            var modalInfo = {value: null, dismissed: true, resendHash: []};
			var modalInstance;
			var controller;
			var openModal = function (template, controller, modalInfo) {
				modalInstance = $modal.open({
					windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
					templateUrl: template,
					controller: controller,
					backdrop: 'static',
					keyboard: false,
					resolve: {
						modalInfo: function () {
							return modalInfo;
						}
					}
				});
			};

			openModal('modules/ui-components/modals/photo-tips/photo-tips_template.html', 'PhotoTipsController', modalInfo);
        };

        angular.extend(this, $controller('PhotoInputController', {$scope: $scope}));
    });
});