define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.controller('PhotoInputController', function ($scope, $rootScope, $timeout, $http, imageRotationService, focusService, imageResponseService, mediaRequestNavigationService, fileValidationService, formatter, $modal) {
        $scope.evaluation = angular.copy(imageResponseService.getEvaluation());
        var android = navigator.userAgent.toLowerCase().indexOf('android') > -1;
        var imageUrl = $scope.image && $scope.image.imageUrl ? $scope.image.imageUrl : '';
        var modalInstance;
        
        $scope.isIE11 = !!window.MSInputMethodContext && !!document.documentMode;
        $scope.currPhoto = {};

        if (imageUrl) {
			$http({
				url: imageUrl,
				method: 'GET'
			}).then(function (response) {
                $scope.currPhoto.src = "data:"+response.data.content.contentType+";base64," + response.data.content.data;
                $scope.image.fileName = response.data.content.title;
				if (android) {
					imageRotationService.getRotateClass(formatter.base64toBlob($scope.currPhoto.src)).then(function (rotateClass) {
						$scope.currPhoto.rotateClass = rotateClass;
					});
				}
			});
        }

        $scope.showDescriptionRequired = !($scope.showImageRequired) && ($scope.image && $scope.image.id) ? true : false;

		$scope.retakePhoto = function () {
			$scope.imageAccepted = false;
			$scope.takePhoto();
		}

        $scope.takePhoto = function() {
            $scope.imageSelected = true;
            $scope.hideNext = true;
			$scope.showDescriptionRequired = !$scope.showImageRequired;
			
            var focusImage = function () {
                $timeout(function () {
                    focusService.focusElement('.media-container img');
                }, 700);
            };

            if (android) {
                imageRotationService.getRotateClass($scope.currPhoto.fileObj).then(function (rotateClass) {
                    $scope.currPhoto.rotateClass = rotateClass;

                    focusImage();
                });
            } else {
                focusImage();
            }
        };

        $scope.photoComments = '';
        $scope.showTakeAnother = $scope.imageNum < 3 && (typeof $scope.nextImage === 'undefined');

        $scope.errorHandling = {
			'File-Size-Check' : {
				message : 'Image file can be no bigger than ' + $scope.imageFileSizeLimit + ' MB.',
				priority : 1
            },
            'File-Type-Check' : {
                message : 'Images must be one of the following types: gif, jpg, jpeg, png',
                priority : 1
            }
        };

        $scope.validate = function () {
            $scope.validateFileSize();
            $scope.validateFileType();
        };

        $scope.validateFileSize = function () {
            var validFileSize = true;

            var maxFileSize = ($scope.imageFileSizeLimit * 1024 * 1024) - 1; //Image file-size limit in MB converted to Bytes, minus 1 Byte per requirement;

            validFileSize = fileValidationService.validateFileSize($scope.currPhoto.fileObj, maxFileSize);

            $scope.photoInputForm.$setValidity('File-Size-Check', validFileSize);
        };
        
        $scope.validateFileType = function () {
            var validFileType = true;
            
            var fileTypes = ['png', 'jpg', 'jpeg', 'gif'];
            var fileName = '';

			if ($scope.currPhoto.fileObj) {
				fileName = $scope.currPhoto.fileObj.name;
			} else if ($scope.image && $scope.image.fileName) {
                fileName = $scope.image.fileName
            }

            validFileType = fileValidationService.validateFileType(fileName, fileTypes);

            $scope.photoInputForm.$setValidity('File-Type-Check', validFileType);
        };

        $scope.acceptPhoto = function() {
            if ($scope.image && $scope.image.imageDescription) {
                $scope.image.imageDescription = $scope.image.imageDescription.trim();
            }
            
            $scope.validate();
            $scope.photoInputForm.validationSummary.validate().then(function () {
                $scope.acceptPhotoCallback();
            });
        };

        $scope.anotherPhoto = function() {
            $scope.validate();
            $scope.photoInputForm.validationSummary.validate().then(function () {
                $scope.anotherPhotoCallback();
                mediaRequestNavigationService.nextPage(false);
            });
        };

        $scope.skipSection = function() {
            $scope.skipSectionCallback();
        };

        $scope.$watch('image.imageDescription', function (newVal, oldVal) {
            if (typeof oldVal === 'undefined' || (oldVal == newVal)) return;
            
            $scope.imageAccepted = false;
            $scope.hideNext = true;
        });

        $scope.removeEmptyImages = function() {
            var tempImageList = [];
            $scope.evaluation.images.forEach(function(img) {
                if (img.id) {
                    tempImageList.push(img);
                }
            });
            $scope.evaluation.images = tempImageList;
        };

        $scope.previous = function () {
            if ($scope.imageSelected && ((typeof($scope.imageAccepted) === 'undefined' && $scope.hideNext) || (typeof($scope.imageAccepted) !== 'undefined' && !$scope.imageAccepted))){
                openModal('modules/ui-components/modals/confirm-media-update/confirm-media-update_template.html', 'ConfirmMediaUpdateController', {headerText: 'Navigating away from image capture'});

                modalInstance.result.then(function (result) {
                    if (result.continue) {
                        imageResponseService.setEvaluation($scope.evaluation);
                        $scope.removeEmptyImages();
                        imageResponseService.initUploadedImagesBySection();
                        mediaRequestNavigationService.previousPage(false);
                    }
                });
            } else {
                $scope.evaluation = imageResponseService.getEvaluation();
                $scope.removeEmptyImages();
                imageResponseService.initUploadedImagesBySection();
                mediaRequestNavigationService.previousPage();
            }
        };

        $scope.next = function () {
            mediaRequestNavigationService.nextPage();
        };

		$scope.swipeLeft = function(){
			$rootScope.$broadcast('swipeLeft');
		};

		$scope.swipeRight = function(){
            if (!$scope.hideNext) {
                $rootScope.$broadcast('swipeRight');
            }
        };
        
        var openModal = function (template, controller, data) {
            var modalInfo = {value: null, dismissed: true, resendHash: []};
            modalInstance = $modal.open({
                windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
                templateUrl: template,
                controller: controller,
                backdrop: 'static',
                keyboard: false,
                resolve: {
                    modalInfo: function () {
                        return modalInfo;
                    },
                    params: function(){
                        return data;
                    }
                }
            });
        };
	});
});
