define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.controller('OptionalPhotoController', function ($scope, $stateParams, $controller, $timeout, focusService, imageResponseService, imageUploadService, mediaRequestNavigationService, configServiceValues) {
        $scope.picType = 'Optional';
        $scope.isOptional = true;
		$scope.additionalPicText = 'Please take additional photos of the area of interest';
		$scope.imageNum = $stateParams.imageNum;
		$scope.image = imageResponseService.getOptionalImage($scope.imageNum - 1)|| {};
        $scope.imageSelected = !!$scope.image && !!($scope.image.id && $scope.image.imageUrl);
        $scope.imageAccepted = $scope.imageSelected;
        $scope.imageTypeTemplate = "modules/applets/mytelederm/pages/photo-input/partials/_not-required-photo.html";
		$scope.nextImage = imageResponseService.getOptionalImage($scope.imageNum);
		$scope.hideNext = !$scope.imageAccepted;
		$scope.showImageRequired = false;
		$scope.imageFileSizeLimit = configServiceValues.imageFileSizeLimit;

		$scope.acceptPhotoCallback = function () {
			if ($scope.currPhoto.fileObj) {
				var data = $scope.image && $scope.image.id ? $scope.image : {
						imageSection: {
							name: 'OPTIONAL',
							description: 'Optional'
						},
						imageType: {
							name: 'OPTIONAL',
							description: 'Optional'
						},
						imageClass: 'OPTIONAL',
						imageDescription: $scope.image.imageDescription,
						imageNumber: $scope.imageNum
					};

				data.fileName = $scope.currPhoto.fileObj.name;

				imageUploadService.uploadImage($scope.currPhoto.fileObj, data).then(function () {
                    $scope.image = imageResponseService.getOptionalImage($scope.imageNum - 1) || {};
					$scope.imageAccepted = true;
					$scope.hideNext = false;
					$timeout(function () {
						focusService.focusElement('#photo-description');
					});
				});
			} else {
				imageResponseService.saveEvaluation().then(function () {
					$scope.imageAccepted = true;
					$scope.hideNext = false;
				});
			}
		};

        $scope.anotherPhotoCallback = function () {
			if (typeof $scope.nextImage === 'undefined' || !($scope.nextImage && $scope.nextImage.id) ) {
				imageResponseService.createImagePlaceholder({
					imageSection: {
						name: 'OPTIONAL',
						description: 'Optional'
					},
					imageType: {
						name: 'OPTIONAL',
						description: 'Optional'
					},
					imageClass: 'OPTIONAL',
					imageNumber: $scope.imageNum+1
				});
			}
        };

        $scope.skipSectionCallback = function () {
            mediaRequestNavigationService.skipToReviewPhotos();
        };

		angular.extend(this, $controller('PhotoInputController', {$scope: $scope}));
    });
});