define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.controller('CloseUpPhotoController', function ($scope, $controller, $stateParams, imageResponseService, mediaRequestNavigationService, imageUploadService, focusService, $timeout, configServiceValues) {
        $scope.picType = 'Close up';
        $scope.isCloseup = true;
        $scope.additionalPicText = 'Please take a close up of the area of interest';
        $scope.imageSection = $stateParams.imageSection;
        $scope.imageNum = $stateParams.imageNum;
        $scope.image = imageResponseService.getCloseUpImage($scope.imageSection.name, $scope.imageNum - 1) || {};
        $scope.imageSelected = !!$scope.image && !!($scope.image.id && $scope.image.imageUrl);
        $scope.imageAccepted = $scope.imageSelected;
        $scope.imageTypeTemplate = "modules/applets/mytelederm/pages/photo-input/partials/_not-required-photo.html";
        $scope.nextImage = imageResponseService.getCloseUpImage($scope.imageSection.name, $scope.imageNum);
        $scope.hideNext = !$scope.imageAccepted;
        $scope.showImageRequired = $scope.imageNum == 1;
        $scope.imageFileSizeLimit = configServiceValues.imageFileSizeLimit;

        $scope.acceptPhotoCallback = function () {
            if ($scope.currPhoto.fileObj) {
                var data = $scope.image && $scope.image.id ? $scope.image : {
                    imageSection: $scope.imageSection,
                    imageType: {
                        name: 'CLOSE_UP',
                        description: 'Close up'
                    },
                    imageClass: 'CLOSE_UP',
                    imageDescription: $scope.image.imageDescription,
                    imageNumber: $scope.imageNum
                };

                data.fileName = $scope.currPhoto.fileObj.name;

                imageUploadService.uploadImage($scope.currPhoto.fileObj, data).then(function () {
                    $scope.image = imageResponseService.getCloseUpImage($scope.imageSection.name, $scope.imageNum - 1) || {};
                    $scope.imageAccepted = true;
                    $scope.hideNext = false;
                    
                    $timeout(function () {
                        focusService.focusElement('#photo-description');
                    });
                });
            } else {
                imageResponseService.saveEvaluation().then(function () {
                    $scope.imageAccepted = true;
                    $scope.hideNext = false;
                });
            }
        };

        $scope.anotherPhotoCallback = function () {
            if (typeof $scope.nextImage === 'undefined' || !($scope.nextImage && $scope.nextImage.id) ) {
                imageResponseService.createImagePlaceholder({
                    imageSection: $scope.imageSection,
                    imageType: {
                        name: 'CLOSE_UP',
                        description: 'Close up'
                    },
                    imageClass: 'CLOSE_UP', 
                    imageNumber: $scope.imageNum+1
                });
            }
        };

        $scope.skipSectionCallback = function () {
            mediaRequestNavigationService.skipToNextSection();
        };

        angular.extend(this, $controller('PhotoInputController', {$scope: $scope}));
    });
});