define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.controller('MedicationsController', function ($scope, $rootScope, $timeout, imageResponseService, mediaRequestNavigationService, medicationTypes, medicationExamples, formatter, focusService) {
		$scope.evaluation = imageResponseService.getEvaluation();

		$scope.medTypes = medicationTypes;
		$scope.medExamples = medicationExamples;

		$scope.toTitleCase = formatter.toTitleCase;

		$scope.setMedTypes = function(medType){
			var index = $scope.evaluation.medicationTypes.indexOf(medType);
			if (index == -1) {
				$scope.evaluation.medicationTypes.push(medType);

				if (medType === 'OTHER') {
					$scope.evaluation.otherMedication =  ''; //clear out system set N/A.
					$timeout(function () {
						focusService.focusElement('#other-medication');
					});
				}
			} else {
				$scope.evaluation.medicationTypes.splice(index,1);
				$scope.evaluation.otherMedication = (medType == 'OTHER') ? '' : $scope.evaluation.otherMedication; //clear out text only if OTHER was unchecked
			}
		};

		$scope.isSelected = function (medType) {
			return ($scope.evaluation.medicationTypes.indexOf(medType) !== -1);
		};

		$scope.previous = function () {
			this.medicationSelectionForm.validationSummary.validate().then(function() {
				$scope.evaluation.otherMedication = !$scope.evaluation.medicationTypes.length ? 'N/A' : $scope.evaluation.otherMedication;
				mediaRequestNavigationService.previousPage();
			});
		};

		$scope.next = function () {
			this.medicationSelectionForm.validationSummary.validate().then(function(){
				$scope.evaluation.otherMedication = !$scope.evaluation.medicationTypes.length ? 'N/A' : $scope.evaluation.otherMedication;
				mediaRequestNavigationService.nextPage();
			});
		};

		$scope.swipeLeft = function(){
			$rootScope.$broadcast('swipeLeft');
		}

		$scope.swipeRight = function(){
			$rootScope.$broadcast('swipeRight');
		}
	});
});
