define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('medicationsEntryService', function ($q, $http, localResourceDirectoryService, $filter) {
        return {
            getMedications: function (medType, val, returnLimit) {
                var deferred = $q.defer();

                localResourceDirectoryService.fetch().then(function(resourceLinks) {
                    $http.get(resourceLinks["medication-codes"], {
                        params: {
                            type: medType,
                            term: val,
                            limit: returnLimit
                        },
                        background: true
                    }).success(function(response) {
                        if (response) {
                            deferred.resolve($filter('orderBy')(response));
                        }
                        else {
                            deferred.resolve([]);
                        }
                    }).error(function (error) {
                        deferred.reject(error);
                    });;
                });

                return deferred.promise;
            }
        };
    });
});