define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.controller('MedicationsEntryController', function ($scope, $rootScope, formatter, $stateParams, imageResponseService, mediaRequestNavigationService, focusService, $timeout, medicationsEntryService) {
		$scope.medType = $stateParams.medType;
		$scope.medFrequencyItems = ["1 time", "2 times", "3 times", "4 times", "5 times", "6 times", "other"];
		$scope.freqOptions = ["a day", "every other day", "a week", "every other week", "a month", "other"];
		$scope.dosesMissedFrequencyItems = ["None", "1 time", "2 times", "3 times",  "4 times", "5 or more times"];
		$scope.medLabelValues = {
			'TOPICAL': {
				applicationMethod: 'apply to',
				frequency: 'use',
				doseHidden: 'Location',
				dose: 'Location: Each time you use this medication, where do you use it?  (e.g., face, all over body)',
				dosesMissed: 'week'
			},
			'ORAL': {
				applicationMethod: 'take for',
				frequency: 'take',
				doseHidden: 'Dose',
				dose: 'Dose: Each time you take this medication, how much do you take?',
				dosesMissed: 'week'
			},
			'INJECTED': {
				applicationMethod: 'inject for',
				frequency: 'inject',
				doseHidden: 'Dose',
				dose: 'Dose: Each time you take this medication, how much do you currently inject?  (e.g., 2 syringes, 1 pen)',
				dosesMissed: 'month'
			}
		};

		var medsByType = imageResponseService.getMedsByType($scope.medType);
		var emptyMed = {
			"type": $scope.medType,
			"name": "",
			"frequency": "",
			"frequencyOther": "",
			"timeUnit": "",
			"timeUnitOther": "",
			"dose": "",
			"missedDoses": ""
		};

		$scope.medications = medsByType.length ? medsByType : [angular.copy(emptyMed)];

		$scope.toTitleCase = formatter.toTitleCase;

		$scope.addNew = function () {
			$scope.medications.push(angular.copy(emptyMed));
			$timeout(function () {
				focusService.focusElement(angular.element('.medication-header:last'));
			});
		};

		$scope.removeMedication = function (index) {
			$scope.medications.splice(index, 1);
			$timeout(function() {
				focusService.focusElement(angular.element('.medication-header:last'));
			});
		};

		$scope.previous = function () {
			trimInputs();
			this.medicationEntryForm.validationSummary.validate().then(function(){
				imageResponseService.updateMedsByType($scope.medications, $scope.medType);
				mediaRequestNavigationService.previousPage();
			});
		};

		$scope.next = function () {
			trimInputs();
			this.medicationEntryForm.validationSummary.validate().then(function(){
				imageResponseService.updateMedsByType($scope.medications, $scope.medType);
				mediaRequestNavigationService.nextPage();
			});
		};

		$scope.items = function(val) {
			var lowerVal = val.toLowerCase();
			return medicationsEntryService.getMedications($scope.medType === 'INJECTED' ? 'INJECTION' : $scope.medType, lowerVal, 20).then(function (meds){
				return meds;
			});
		};

		$scope.selectMedication = function(item, index) {
			$scope.medications[index].name = item;
		};

		$scope.onFrequencyChange = function(newValue) {
			if(newValue !== 'other')
				this.med.frequencyOther = "";
		};

		$scope.onTimeUnitChange = function(newValue) {
			if(newValue !== 'other')
				this.med.timeUnitOther = "";
		};

		$scope.swipeLeft = function(){
			$rootScope.$broadcast('swipeLeft');
		}

		$scope.swipeRight = function(){
			$rootScope.$broadcast('swipeRight');
		}

		function trimInputs() {
			$scope.medications.forEach(function(med){
				med.name = med.name ? med.name.trim() : '';
				med.frequencyOther = med.frequencyOther ? med.frequencyOther.trim() : '';
				med.timeUnitOther = med.timeUnitOther ? med.timeUnitOther.trim() : '';
				med.dose = med.dose ? med.dose.trim() : '';
			});
		}
	});
});