define(['medicationsEntryService'], function() {
    'use strict';

    describe("The medicationsEntry Service", function () {
        var service,
            httpMock,
            localResourceDirectoryServiceMock;

        beforeEach(function () {
            module('angularTemplateApp');

            localResourceDirectoryServiceMock = jasmine.createSpyObj('localResourceDirectoryServiceMock', ['fetch']);

            localResourceDirectoryServiceMock.fetch.and.returnValue({
                then: function (callback) {
                    callback({
                        'medication-codes': '../CodeableConceptService/v2/public/coding/skinmedications'
                    });
                }
            });

            module(function ($provide) {
                $provide.value('localResourceDirectoryService', localResourceDirectoryServiceMock);
            });

            inject(function(medicationsEntryService, $httpBackend) {
                service = medicationsEntryService;
                httpMock = $httpBackend;
            });
        });
        
        describe("getMedications resolve with data", function (){
            it ("should resolve with a list of medications", function() {
                var meds = ["Benzaclin Gel 1%", "Benzaclin Gel 5%", "Benzamycin"];
                var response;
                
                httpMock.expectGET('../CodeableConceptService/v2/public/coding/skinmedications?limit=3&term=ben&type=TOPICAL').respond(200, meds);
                service.getMedications('TOPICAL', 'ben', 3).then(function (data) {
                    response = data;
                });

                httpMock.flush();

                expect(localResourceDirectoryServiceMock.fetch).toHaveBeenCalled();
                expect(response).toEqual(meds);
            });          
        });

        describe("getMedications resolve with empty array", function (){
            it ("should resolve with a list of medications", function() {
                var response;
                
                httpMock.expectGET('../CodeableConceptService/v2/public/coding/skinmedications?limit=3&term=ben&type=TOPICAL').respond(200, null);
                service.getMedications('TOPICAL', 'ben', 3).then(function (data) {
                    response = data;
                });

                httpMock.flush();

                expect(localResourceDirectoryServiceMock.fetch).toHaveBeenCalled();
                expect(response).toEqual([]);
            });          
        });
        
        describe("getMedications reject", function (){
            it ("should reject with an error", function() {
                var response;
                
                httpMock.expectGET('../CodeableConceptService/v2/public/coding/skinmedications?limit=3&term=ben&type=TOPICAL').respond(400, 'error');
                service.getMedications('TOPICAL', 'ben', 3).then(function (data) {
                    //Empty success function
                }, function (error){
                    response = error;
                });

                httpMock.flush();

                expect(localResourceDirectoryServiceMock.fetch).toHaveBeenCalled();
                expect(response).toEqual('error');
			});
		});
    });
});