define(['TeledermRequestsService','localResourceDirectoryService','CollectionCRUDService','BaseCRUDService'], function() {
	'use strict';

	describe("Telederm Requests Service - mediaRequests", function() {
		var scope,
			service,
			formatterMock,
			localResourceDirectoryMock,
			localResourceDirectory = {
				"media-requests" : "/media-request-service/v1/patients/{UNIQUE_ID}/requests"
			},
			filter,
			config,
			deferredSave,
			mockResponse = {
			"requests": {
				"content":[
					{	"status":"PENDING",
						"requestType":"IMAGE",
						"id":"5a566a22f6ba3c0719279a87",
						"dateRange":{"startDate":"2018-01-06","endDate":"2018-02-12"},
						"patientICN":"1006088937",
						"requestReason":"requestReasonText"},
					{	"status":"SUBMITTED",
						"requestType":"IMAGE",
						"id":"5a566a22f6ba3c0719279a87",
						"dateRange":{"startDate":"2018-02-06","endDate":"2018-03-12"},
						"patientICN":"1006088937",
						"requestReason":"requestReasonText"}]
			},
			"counts":{"PENDING":1}
			},
			mockResponseSorted = {
				"requests": {
					"content":[
						{	"status":"SUBMITTED",
							"requestType":"IMAGE",
							"id":"5a566a22f6ba3c0719279a87",
							"dateRange":{"startDate":"2018-02-06","endDate":"2018-03-12"},
							"startDate":"Fake_FrontendDate",
							"endDate":"Fake_FrontendDate",
							"patientICN":"1006088937",
							"requestReason":"requestReasonText"},
						{	"status":"PENDING",
							"requestType":"IMAGE",
							"id":"5a566a22f6ba3c0719279a87",
							"dateRange":{"startDate":"2018-01-06","endDate":"2018-02-12"},
							"startDate":"Fake_FrontendDate",
							"endDate":"Fake_FrontendDate",
							"patientICN":"1006088937",
							"requestReason":"requestReasonText"}]
				},
				"counts":{"PENDING":1}
			},
			mediaRequestTypesMock = {Image: 'IMAGE'};

		beforeEach(function() {
			module('angularTemplateApp');
			formatterMock = jasmine.createSpyObj('formatter', ['getFormattedBackendDate', 'getFormattedFrontendDate']);
			formatterMock.getFormattedBackendDate.and.returnValue("Fake_BackendDate");
			formatterMock.getFormattedFrontendDate.and.returnValue("Fake_FrontendDate");
			localResourceDirectoryMock = jasmine.createSpyObj('localResourceDirectoryService', ['fetch']);

			module(function($provide) {
				$provide.value('formatter', formatterMock);
				$provide.value('mediaRequestTypes', mediaRequestTypesMock);
				$provide.value('localResourceDirectoryService', localResourceDirectoryMock);
			});


			inject(function(TeledermRequestsService, CollectionCRUDService,BaseCRUDService , $q, $rootScope, $filter) {
				service =  TeledermRequestsService;
				var deferredResource = $q.defer();
				deferredSave = $q.defer();
				deferredResource.resolve(localResourceDirectory);
				localResourceDirectoryMock.fetch.and.returnValue(deferredResource.promise);
				scope = $rootScope;
				filter = $filter;
			});

		});

		describe("when instantiated", function() {
			it("config should be defined correctly", function() {
			 	expect(service.config).toBeDefined();
				expect(service.config.dependency).toBeDefined();
				expect(service.config.dependency.service).toBeDefined();
				expect(service.config.dependency.linkTitles).toBeDefined();
				expect(service.config.dependency.linkTitles.GET).toBeDefined();
				expect(service.config.dependency.linkTitles.GET).toEqual('media-requests');
				expect(service.config.collection).toBeDefined();
				expect(service.config.collection.name).toBeDefined();
				expect(service.config.collection.name).toEqual('requests');
				expect(service.config.object.uidKey).toBeDefined();
				expect(service.config.object.responseTransform).toBeDefined();
				expect(service.config.object.requestTransform).toBeDefined();
				expect(service.sort).toBeDefined();
				expect(service.fetch).toBeDefined();

			});
		});

		describe("methods", function() {

			it("should provide a valid request formatter", function () {
				var date = new Date(),
					formattedDate = ("0" + (date.getMonth() + 1)).slice(-2) + "/" + ("0" + date.getDate()).slice(-2) + "/" + date.getFullYear(),
					item = {
						startDate: formattedDate,
						endDate: formattedDate,
						status: "Pending",
						requestType: "IMAGE"
					};

				expect(item.startDate).toBe(formattedDate);
				expect(item.endDate).toBe(formattedDate);
				expect(service.config.object.requestTransform(item)).toEqual({
					startDate: "Fake_BackendDate",
					endDate: "Fake_BackendDate",
					status: "PENDING",
					requestType: "IMAGE"
				});
			});

			it("should provide a valid response formatter", function () {
				service.config.object.responseTransform(mockResponse);
				expect(formatterMock.getFormattedFrontendDate).toHaveBeenCalledWith("2018-01-06");
				expect(formatterMock.getFormattedFrontendDate).toHaveBeenCalledWith("2018-02-12");
				expect(mockResponse.requests.content[0].startDate).toEqual("Fake_FrontendDate");
				expect(mockResponse.requests.content[0].endDate).toEqual("Fake_FrontendDate");

			});

			it("should provide a list sorter", function () {
				var list = service.sort(mockResponse.requests.content,'status',true);
				expect(list[0].status).toEqual("SUBMITTED");
			});


			it("should fetch and sort the data by start date", function () {
				//Mock the functions called in fetch
				service._onRequestComplete = function (item) {
					return deferredSave.promise;
				};
				service.BaseCRUDService = {
					fetch: function (mock) {
						return mock;
					}
				};

				deferredSave.resolve(mockResponse);

				service.fetch({});

				scope.$apply();

				expect(service.dataPointers.filters).toEqual({});
				expect(service.dataPointers.list).toEqual(mockResponseSorted.requests.content);

			});
		});
	});

});