define(['angular', 'app', 'localResourceDirectoryService'], function (angular, app) {
	'use strict';
	app.service('TeledermRequestsService', function (localResourceDirectoryService,CollectionCRUDService,formatter,$filter, mediaRequestTypes) {

		var TeledermRequestsService = function(){
			this.requestType = mediaRequestTypes.Image;
			var config = {};

			config.dependency = {
				service : localResourceDirectoryService,
				linkTitles : {
					GET : "media-requests",
					POST : "media-requests"
				}
			};

			config.collection = {
				objectType : "MediaRequests",
				name: "requests",
				sortComparator : [{key: "startDate", reverse: true}]
			};

			config.object = {
				uidKey : "_id",
				requestTransform : function(item) {
					item.startDate = formatter.getFormattedBackendDate(item.startDate);
					item.endDate = formatter.getFormattedBackendDate(item.endDate);

					if(item.status) {
						if (item.status.toLowerCase() === "all") { //backend default is all
							delete item.status;
						}
						else {
							item.status = item.status.toUpperCase();
						}
					}
					
					return item;
				},
				responseTransform : function(response) {
					if (response[config.collection.name] && response[config.collection.name].content) {
						response[config.collection.name].content.forEach(function (item) {
							item.startDate = formatter.getFormattedFrontendDate(item.dateRange.startDate);
							item.endDate = formatter.getFormattedFrontendDate(item.dateRange.endDate);
						});
					}

					return response;
				}
			};

			CollectionCRUDService.call(this, config);

			this.sort = function(list, sortKey,reverse) {
				return $filter('orderBy')(list, sortKey, reverse);
			};


			this.fetch = function (queryParams) {
				var that = this,
					localQueryParams = angular.copy(queryParams);

				var requestPromise = that._onRequestComplete(that.BaseCRUDService.fetch(localQueryParams));

				requestPromise.then(function (response) {
					that.dataPointers.filters = angular.copy(queryParams);
					that.dataPointers.list = that.sort(response[that.config.collection.name].content, that.config.collection.sortComparator[0].key, that.config.collection.sortComparator[0].reverse);
					that.dataPointers.unfilteredItemCount = that.dataPointers.list ? that.dataPointers.list.length : 0;
				});
				return requestPromise;
			};

		};

		TeledermRequestsService.prototype = Object.create(CollectionCRUDService.prototype);
		TeledermRequestsService.prototype.constructor = TeledermRequestsService;

		return new TeledermRequestsService();
	});
});
