define(['angular', 'app', 'TeledermRequestsService'], function (angular, app) {
	'use strict';
	app.controller('TeledermRequestsController', function ($scope, $controller, TeledermRequestsService, imageMediaRequestService) {
        $scope.imageIcon = 'icon icon-photo';

        $scope.filterFormHeader = 'Search Follow-up Requests';

        $scope.service =  TeledermRequestsService;
		$scope.requestType = TeledermRequestsService.requestType;

        $scope.table = {
            columns : [
                {label: "Dates", keys: "startDate", hyphenateAndAppendKeys: "endDate", reverse: true, isSortKey: true},
                {label: "Request Reason", reverse: false, isSortKey: false, keys: "requestReason", class: {column: "hidden-xs media-request-reason-col"}},
                {label: "Status", keys: "status", reverse: false, isSortKey: false}
            ]
        };

        $scope.selectEvalCallback = function(mediaRequest) {
            return imageMediaRequestService.setMediaRequest(mediaRequest);
        };

        $scope.routeBase = 'main.mytelederm.media-request';

        angular.extend(this, $controller('MediaRequestsController', {$scope: $scope}));
	});
});
