define(['TeledermRequestsController'], function() {
	'use strict';

	describe("The Telederm Requests Controller", function () {
		var controller,
			scope,
			globalDelayTrackerMock,
			TeledermRequestsServiceMock,
			focusServiceMock;

		beforeEach(function () {
			module('angularTemplateApp');

			globalDelayTrackerMock = jasmine.createSpyObj('globalDelayTracker', ['active']);
			TeledermRequestsServiceMock = jasmine.createSpyObj('TeledermRequestsService', ['fetch','sort']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);

			TeledermRequestsServiceMock.fetch.and.callFake(function () {
				scope.service.dataPointers =
				{
					list: [],
					filters: [],
					unfilteredItemCount: 0
				};
				scope.service.config =
				{
					collection: {
						objectType : "MediaRequests",
						name: "requests",
						sortComparator : [{key: "startDate", reverse: true}]
					}
				};
				return "";
			});

			module(function ($provide) {
				$provide.value('globalDelayTracker', globalDelayTrackerMock);
				$provide.value('TeledermRequestsService', TeledermRequestsServiceMock);
				$provide.value('imageMediaRequestService', {});
				$provide.value('focusService', focusServiceMock);
			});

			inject(function($controller, $rootScope) {
				scope = $rootScope.$new();
				scope.service = TeledermRequestsServiceMock;
				scope.service.fetch();
				controller = $controller;
			});
		});

		describe("setting the table", function () {
			it("should have table defined", function () {
				controller = controller('TeledermRequestsController', {$scope: scope});
				scope.$apply();
				expect(scope.table).toBeDefined();
				expect(scope.table.columns).toBeDefined();
				expect(scope.table.columns.length).toEqual(3);
				expect(scope.table.columns[0].keys).toBeDefined();
				expect(scope.table.columns[0].label).toBeDefined();
				expect(scope.table.columns[0].reverse).toBeDefined();
				expect(scope.table.columns[0].isSortKey).toBeDefined();
				expect(scope.table.columns[1].class).toBeDefined();
				expect(scope.table.columns[1].class.column).toBeDefined();

				expect(scope.table.columns[0].keys).toEqual('startDate');
				expect(scope.table.columns[0].label).toEqual('Dates');
				expect(scope.table.columns[0].hyphenateAndAppendKeys).toEqual('endDate');
				expect(scope.table.columns[1].keys).toEqual('requestReason');
				expect(scope.table.columns[1].label).toEqual('Request Reason');
				expect(scope.table.columns[2].keys).toEqual('status');
				expect(scope.table.columns[2].label).toEqual('Status');
			});
		});

		describe("mytelederm image icon", function () {
			it("should have image icon class set", function () {
				controller = controller('TeledermRequestsController', {$scope: scope});
				scope.$apply();
				expect(scope.imageIcon).toEqual('icon icon-photo');
			});
		});

		describe("mytelederm route", function () {
			it("should have route base set", function () {
				controller = controller('TeledermRequestsController', {$scope: scope});
				scope.$apply();
				expect(scope.routeBase).toEqual('main.mytelederm.media-request');
			});
		});

	});
});