define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.controller('TeledermRequestInfoController', function ($scope, $state, imageMediaRequestService, mediaRequestProgressService, progressService, mediaRequestNavigationService, $controller) {
        $scope.mediaRequest = imageMediaRequestService.getMediaRequest();
		$scope.continueText = 'Continue';
        $scope.viewSubmittedText = 'View Submitted Photos';
        $scope.requestInfoTemplate = "modules/applets/mytelederm/pages/media-request-info/partials/_telederm-request-info.html";

        $scope.routeBase = 'main.mytelederm';

        $scope.continueCallback = function () {
			progressService.setProgressServiceInstance(mediaRequestProgressService);
            mediaRequestNavigationService.resume();
        };

        $scope.reviewCallback = function () {
            $state.go('main.mytelederm.review-submitted-photos');
        };

        angular.extend(this, $controller('MediaRequestInfoController', {$scope: $scope}));
    });
});