define(['TeledermRequestInfoController'], function() {
    'use strict';

    describe("The Telederm Media Request Info Controller", function () {
        var controller,
            scope,
            stateMock,
            imageMediaRequestServiceMock,
            mediaRequestProgressServiceMock = { name: "mediaRequestProgressService" },
            mediaRequestNavigationServiceMock,
            progressServiceMock,
            mediaRequest = {
                mediaTypes: [],
                providerContacts: []
            };

        beforeEach(function () {
            module('angularTemplateApp');

            stateMock = jasmine.createSpyObj('$state', ['go']);
            imageMediaRequestServiceMock = jasmine.createSpyObj('imageMediaRequestService', ['getMediaRequest']);
            mediaRequestNavigationServiceMock = jasmine.createSpyObj('mediaRequestNavigationService', ['resume']);
            progressServiceMock = jasmine.createSpyObj('progressService', ['setProgressServiceInstance']);

            imageMediaRequestServiceMock.getMediaRequest.and.callFake(function () {
                return mediaRequest;
            });

            module(function ($provide) {
                $provide.value('$state', stateMock);
                $provide.value('imageMediaRequestService', imageMediaRequestServiceMock);
                $provide.value('mediaRequestProgressService', mediaRequestProgressServiceMock);
                $provide.value('mediaRequestNavigationService', mediaRequestNavigationServiceMock);
                $provide.value('progressService', progressServiceMock);
            });

            inject(function($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

        describe("Initial state", function () {
            beforeEach(function () {
                controller = controller('TeledermRequestInfoController', {$scope: scope});
            });

            it("should correctly set initial values", function () {
                scope.$apply();

                expect(scope.continueText).toEqual('Continue');
                expect(scope.viewSubmittedText).toEqual('View Submitted Photos');
                expect(scope.routeBase).toEqual('main.mytelederm');
            });
        });

        describe('continueCallback function', function () {
            it ('should set the progressInstanceService and go to the next page', function () {
                controller = controller('TeledermRequestInfoController', {$scope: scope});
                scope.continueCallback();
                expect(progressServiceMock.setProgressServiceInstance).toHaveBeenCalledWith(mediaRequestProgressServiceMock);
                expect(mediaRequestNavigationServiceMock.resume).toHaveBeenCalled();
            });
        });

        describe('reviewCallback function', function () {
            it ('should go to the review submitted photos page', function () {
                controller = controller('TeledermRequestInfoController', {$scope: scope});
                scope.reviewCallback();
                expect(stateMock.go).toHaveBeenCalledWith('main.mytelederm.review-submitted-photos');
            });
        });
    });
});