define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.controller('AdditionalCommentsController', function ($scope, $rootScope, $timeout, focusService, imageResponseService, mediaRequestNavigationService) {
        $scope.evaluation = imageResponseService.getEvaluation();
        $scope.hasAdditionalComments = $scope.evaluation.additionalComments === 'N/A' ? false : !!$scope.evaluation.additionalComments || null;

        $scope.updateComments = function (hasComments) {
            $scope.hasAdditionalComments = hasComments;

            if ($scope.hasAdditionalComments == false) {
                $scope.evaluation.additionalComments = 'N/A';
            } else if ($scope.hasAdditionalComments) {
                $scope.evaluation.additionalComments = '';
                $timeout(function () {
                    focusService.focusElement('#additional-comments');
                });
            }
        };

        $scope.validate = function () {
            var optionSelected = true;
            
			if ($scope.hasAdditionalComments === null) {
				optionSelected = false;
			}

            $scope.additionalCommentsForm.$setValidity('Additional-Comments-Required', optionSelected);
        };

        $scope.previous = function () {
            $scope.validate();
            $scope.additionalCommentsForm.validationSummary.validate().then(function(){
                mediaRequestNavigationService.previousPage();
			});
        };

        $scope.next = function () {
            $scope.validate();
            $scope.additionalCommentsForm.validationSummary.validate().then(function(){
				mediaRequestNavigationService.nextPage();
			});
        };

		$scope.errorHandling = {
			'Additional-Comments-Required' : {
				message : 'Please select appropriate additional comments choice before proceeding further.',
				priority : 1
            }
		};

		$scope.swipeLeft = function(){
			$rootScope.$broadcast('swipeLeft');
		};

		$scope.swipeRight = function(){
			$rootScope.$broadcast('swipeRight');
        };
	});
});
