define([
    'angular',
    'app',
    'teledermSubmitStatusValue',
    'medicationTypesValue',
    'mediaRequestTypes',
    'TeledermRequestsController',
    'TeledermRequestInfoController',
    'SubheaderController',
    'TeledermEvalController',
    'SkinStatusController',
    'MedicationsController',
    'MedicationsEntryController',
    'AdditionalCommentsController',
    'ResponseSummaryController',
	'PhotoInstructionsController',
    'PhotoInputController',
    'RequiredPhotoController',
    'CloseUpPhotoController',
	'TakeAnotherPictureController',
    'OptionalPhotoController',
    'ReviewPhotosController',
    'TeledermSubmitController',
    'TeledermRetryController',
    'mediaRequestNavigationService',
    'mediaRequestProgressService',
    'imageMediaRequestService',
    'imageResponseService',
    'medicationsEntryService',
    'imageRotationService',
    'imageUploadService',
    'teledermSubmitEvaluationService',
    'configValuesService'
], function (angular, app, teledermSubmitStatusValue) {
	'use strict';

	app.config(function ($stateProvider) {
        $stateProvider
            .state('main.mytelederm', {
                url: '/mytelederm',
                appNavIndex: 2,
                data:{
                    appletName: "My Telederm"
                },
                views: {
                    "": {
                        templateUrl: 'modules/container/components/content/single-column_template.html'
                    },
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/media-requests/media-requests_template.html',
                        controller: 'TeledermRequestsController'
                    }
                }
            })
            .state('main.mytelederm.media-request-info', {
				views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'SubheaderController'
                    },
                    'content@main.mytelederm.media-request-info': {
						templateUrl: 'modules/applets/shared/pages/media-request-info/media-request-info_template.html',
                        controller: 'TeledermRequestInfoController'
                    }
                },
                params: {
                    subtitle: 'Follow-Up Request Details'
                }
            })
            .state('main.mytelederm.skin-status', {
                views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
                    'content@main.mytelederm.skin-status': {
                        templateUrl: 'modules/applets/mytelederm/pages/skin-status/skin-status_template.html',
                        controller: 'SkinStatusController'
                    }
                }
            })
            .state('main.mytelederm.medications', {
				views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
					'content@main.mytelederm.medications': {
						templateUrl: 'modules/applets/mytelederm/pages/medications/medications_template.html',
						controller: 'MedicationsController'
					}
                }
            })
			.state('main.mytelederm.medications-entry', {
				views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
					'content@main.mytelederm.medications-entry': {
						templateUrl: 'modules/applets/mytelederm/pages/medications/medications-entry_template.html',
						controller: 'MedicationsEntryController'
					}
				},
                params: {
                    medType: null
                }
			})
            .state('main.mytelederm.additional-comments', {
                views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
                    'content@main.mytelederm.additional-comments': {
                        templateUrl: 'modules/applets/mytelederm/pages/additional-comments/additional-comments_template.html',
                        controller: 'AdditionalCommentsController'
                    }
                }
            })
            .state('main.mytelederm.response-summary', {
				views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
					'content@main.mytelederm.response-summary': {
						templateUrl: 'modules/applets/mytelederm/pages/response-summary/response-summary_template.html',
                        controller: 'ResponseSummaryController'
					}
				}
            })
            .state('main.mytelederm.photo-instructions', {
				views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
					'content@main.mytelederm.photo-instructions': {
						templateUrl: 'modules/applets/mytelederm/pages/photo-instructions/photo-instructions_template.html',
						controller: 'PhotoInstructionsController'
					}
				}
			})
            .state('main.mytelederm.photo-input', {
				views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
					'content@main.mytelederm.photo-input': {
						templateUrl: 'modules/applets/mytelederm/pages/photo-input/photo-input_template.html',
                        controller: 'RequiredPhotoController'
					}
                },
                params: {
                    imageSection: null,
                    imageType: null,
                    imageNum: null,
                    totalImagesInSection: null
                },
                resolve: {
                    configServiceValues: function (configValuesService) {
                        return configValuesService.fetch('file-size-limits');
                    }
                }
            })
            .state('main.mytelederm.photo-input-close-up', {
				views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
					'content@main.mytelederm.photo-input-close-up': {
						templateUrl: 'modules/applets/mytelederm/pages/photo-input/photo-input_template.html',
                        controller: 'CloseUpPhotoController'
					}
                },
                params: {
                    imageSection: null,
                    imageNum: null
                },
                resolve: {
                    configServiceValues: function (configValuesService) {
                        return configValuesService.fetch('file-size-limits');
                    }
                }
            })
            .state('main.mytelederm.take-another-picture', {
                views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
                    'content@main.mytelederm.take-another-picture': {
                        templateUrl: 'modules/applets/mytelederm/pages/take-another-picture/take-another-picture_template.html',
                        controller: 'TakeAnotherPictureController'
                    }
                }
            })
            .state('main.mytelederm.photo-input-optional', {
				views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
					'content@main.mytelederm.photo-input-optional': {
						templateUrl: 'modules/applets/mytelederm/pages/photo-input/photo-input_template.html',
                        controller: 'OptionalPhotoController'
					}
                },
                params: {
                    imageNum: null
                },
                resolve: {
                    configServiceValues: function (configValuesService) {
                        return configValuesService.fetch('file-size-limits');
                    }
                }
            })
            .state('main.mytelederm.review-photos', {
                views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
                    'content@main.mytelederm.review-photos': {
                        templateUrl: 'modules/applets/mytelederm/pages/review-photos/review-photos_template.html',
                        controller: 'ReviewPhotosController'
                    }
                }
            })
            .state('main.mytelederm.review-submitted-photos', {
                views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'SubheaderController'
                    },
                    'content@main.mytelederm.review-submitted-photos': {
                        templateUrl: 'modules/applets/mytelederm/pages/review-photos/review-photos_template.html',
                        controller: 'ReviewPhotosController'
                    }
                },
                params: {
                    subtitle: 'Follow-Up Appointment Submitted Photos',
                    submitted: true
                }
            })
            .state('main.mytelederm.submit', {
                views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermEvalController'
                    },
                    'content@main.mytelederm.submit': {
                        templateUrl: 'modules/applets/shared/pages/submit/submit_template.html',
                        controller: 'TeledermSubmitController'
                    }
                }
            })
            .state('main.mytelederm.success', {
                views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'SuccessController'
                    },
                    'content@main.mytelederm.success': {
                        templateUrl: 'modules/applets/shared/pages/submit-status/submit-status_template.html'
                    }
                },
                params: teledermSubmitStatusValue
            })
            .state('main.mytelederm.retry', {
                views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'TeledermRetryController'
                    },
                    'content@main.mytelederm.retry': {
                        templateUrl: 'modules/applets/shared/pages/submit-status/submit-status_template.html'
                    }
                },
                params: teledermSubmitStatusValue
            })
            .state('main.mytelederm.failed', {
                views: {
                    'primary@main.mytelederm': {
                        templateUrl: 'modules/applets/shared/pages/subheader/subheader-content_template.html',
                        controller: 'FailedController'
                    },
                    'content@main.mytelederm.failed': {
                        templateUrl: 'modules/applets/shared/pages/submit-status/submit-status_template.html'
                    }
                },
                params: angular.extend({
                    providerType: 'Dermatologist'
                }, teledermSubmitStatusValue)
            });
	});
});