define(['LandingController'], function() {
    'use strict';

    describe("The Landing Page controller", function () {
        var controller,
            scope,
			windowMock = window,
			modalMock,
			patientServiceMock,
			focusServiceMock,
			authServiceMock,
			state,
            q,
	        formValidateDeferred,
			isAuthenticated = false;

        beforeEach(function () {
            module('angularTemplateApp');

			patientServiceMock = jasmine.createSpyObj('patient', ['fetch']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);
			authServiceMock = jasmine.createSpyObj('authenticationService', ['isAuthenticated']);
			modalMock = jasmine.createSpyObj('$modal', ['open']);

			patientServiceMock.fetch.and.returnValue({then: function () {} });
			authServiceMock.isAuthenticated.and.callFake(function(){
				return isAuthenticated;
			});

            module(function ($provide) {
				$provide.value('patient', patientServiceMock);
				$provide.value('focusService', focusServiceMock);
				$provide.value('authenticationService', authServiceMock);
				$provide.value('$modal', modalMock);
            });

            inject(function($controller, $rootScope, $state, $q) {
                scope = $rootScope.$new();
				state = $state;
				q = $q;
                controller = $controller('LandingController', {$scope: scope});

	            formValidateDeferred = q.defer();
				scope.initialForm = {
					validationSummary: {
						validate: function() {
							return formValidateDeferred.promise;
						}
					}
				};
            });
        });

        it ( "should have scope values initialized", function () {
            expect(scope.errors).toEqual([]);
        });

        it ("should focus the header", function () {
			expect(focusServiceMock.focusMain).toHaveBeenCalled();
		});

		it ("should not request patient data for username - not authenticated", function () {
			expect(patientServiceMock.fetch).not.toHaveBeenCalled();
			//Setting isAuthenticated for next test
			isAuthenticated = true;
		});

		it ("should request patient data for username - authenticated", function () {
			expect(patientServiceMock.fetch).toHaveBeenCalled();
		});

		describe("when Learn more link is clicked", function (){
			beforeEach( function () {
				spyOn(windowMock, 'open');
				scope.showUserGuide();
			});

			it ("should open a new browser window to the notification section of the user guide", function() {
				expect(windowMock.open).toHaveBeenCalledWith("modules/ui-components/modals/help/guide/guide.html#/features/notifications", "_blank", "location=no,scrollbars=1,resizable=1");
			});
		});

		describe("when dial 911 link is clicked", function (){
			it ("should open a modal with href 911", function() {
				var obj = {currentTarget : {id : 'btn911'}};
				scope.dial911(obj);

				var modalObject = modalMock.open.calls.argsFor(0)[0];

				expect(modalObject.windowTemplateUrl).toEqual('modules/ui-components/modals/helper/modal-window_template.html');
				expect(modalObject.templateUrl).toEqual('modules/ui-components/modals/confirm-dial/confirm-dial_template.html');
				expect(modalObject.controller).toEqual('ConfirmDialController');
				expect(modalObject.backdrop).toEqual('static');
				expect(modalObject.keyboard).toEqual(false);
				expect(modalObject.resolve.params()).toEqual({id:"btn911", href: "911" });

			});
		});

		describe("when dial Veteran Crisis Line link is clicked", function (){
			it ("should open a modal with href 1-800-273-8255", function() {
				var obj = {currentTarget : {id : 'btnVeteranCrisisLine'}};
				scope.dialVeteranCrisisLine(obj);

				var modalObject = modalMock.open.calls.argsFor(0)[0];

				expect(modalObject.windowTemplateUrl).toEqual('modules/ui-components/modals/helper/modal-window_template.html');
				expect(modalObject.templateUrl).toEqual('modules/ui-components/modals/confirm-dial/confirm-dial_template.html');
				expect(modalObject.controller).toEqual('ConfirmDialController');
				expect(modalObject.backdrop).toEqual('static');
				expect(modalObject.keyboard).toEqual(false);
				expect(modalObject.resolve.params()).toEqual({id:"btnVeteranCrisisLine", href: "1-800-273-8255" });
			});
		});

		describe("when view VA Facilities link is clicked", function (){
			it ("should open a modal with href https://www.vets.gov/facilities/", function() {
				var obj = {currentTarget : {id : 'btnViewVAFacilities'}};
				scope.viewVAFacilities(obj);

				var modalObject = modalMock.open.calls.argsFor(0)[0];

				expect(modalObject.windowTemplateUrl).toEqual('modules/ui-components/modals/helper/modal-window_template.html');
				expect(modalObject.templateUrl).toEqual('modules/ui-components/modals/confirm-navigation/confirm-navigation_template.html');
				expect(modalObject.controller).toEqual('ConfirmNavigationController');
				expect(modalObject.backdrop).toEqual('static');
				expect(modalObject.keyboard).toEqual(false);
				expect(modalObject.resolve.params()).toEqual({id:"btnViewVAFacilities", href: "https://www.vets.gov/facilities/" });

			});
		});
    });
});