define(['angular', 'app'], function (angular, app) {
	'use strict';

	app.controller('LandingController', function ($scope, $state, $modal, patient, authenticationService, focusService) {
		var modalInstance;
		var controller;

		var openModal = function (template, controller, data) {
			var modalInfo = {value: null, dismissed: true, resendHash: []};
			modalInstance = $modal.open({
				windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
				templateUrl: template,
				controller: controller,
				backdrop: 'static',
				keyboard: false,
				resolve: {
					modalInfo: function () {
						return modalInfo;
					},
					params: function(){
						return data;
					}
				}
			});
		};

		$scope.errors = [];

        focusService.focusMain();

        $scope.showTour = function () {
			openModal('modules/applets/home/carousel-tour/carousel_template.html', 'TourController', null);
		};

		$scope.beginLogon = function () {
			authenticationService.authenticate();
		};

        $scope.isAuthenticated = authenticationService.isAuthenticated();

		$scope.today = new Date();

        function init(){
			focusService.focusMain();

			patient.fetch().then(function (result) {
				$scope.patientData = result;
			});
		}

		$scope.showUserGuide = function () {
			window.open("modules/ui-components/modals/help/guide/guide.html#/features/notifications", "_blank", "location=no,scrollbars=1,resizable=1");
		};

		//only process init if user is logged in, otherwise the login will show
		if ($scope.isAuthenticated) {
			init();
		}

		$scope.dial911 = function (event) {
			openModal('modules/ui-components/modals/confirm-dial/confirm-dial_template.html', 'ConfirmDialController', {id: event.currentTarget.id, href: "911"});
		};

		$scope.dialVeteranCrisisLine = function (event) {
			openModal('modules/ui-components/modals/confirm-dial/confirm-dial_template.html', 'ConfirmDialController', {id: event.currentTarget.id, href: "1-800-273-8255"});
		};

		$scope.viewVAFacilities = function (event) {
			openModal('modules/ui-components/modals/confirm-navigation/confirm-navigation_template.html', 'ConfirmNavigationController', {id: event.currentTarget.id, href: "https://www.vets.gov/facilities/"});
		};
		
	});
});
