define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('appSelectService', function ($http, $q, localResourceDirectoryService, formatter) {
		var endDate = formatter.getFormattedBackendDate(formatter.getDateTimeMinusDelta(new Date(), {days: 270}));
		var startDate = formatter.getFormattedBackendDate(formatter.getDateTimeMinusDelta(new Date(), {days: -90}));

		return {
			fetchMediaRequestCounts: function (requestType) {
				var deferred = $q.defer();

				localResourceDirectoryService.fetch().then(function (resourceLinks) {
					$http.get(resourceLinks['requests-count'], {
						params: {
							requestStatus: 'pending',
							requestType: requestType,
							startDate: startDate,
							endDate: endDate
						}
					}).success(function (requestCount) {
						deferred.resolve(requestCount);
					}).error(function (error) {
						deferred.reject(error);
						deferred = null;
					});
				});

				return deferred.promise;
			}
		}
	});
});